/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Elements
implements List<Element>,
Cloneable {
    private List<Element> contents;

    public Elements() {
        this.contents = new ArrayList<Element>();
    }

    public Elements(int initialCapacity) {
        this.contents = new ArrayList<Element>(initialCapacity);
    }

    public Elements(Collection<Element> elements) {
        this.contents = new ArrayList<Element>(elements);
    }

    public Elements(List<Element> elements) {
        this.contents = elements;
    }

    public Elements(Element ... elements) {
        this(Arrays.asList(elements));
    }

    public Elements clone() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element e : this.contents) {
            elements.add(e.clone());
        }
        return new Elements((List<Element>)elements);
    }

    public String attr(String attributeKey) {
        for (Element element2 : this.contents) {
            if (!element2.hasAttr(attributeKey)) continue;
            return element2.attr(attributeKey);
        }
        return "";
    }

    public boolean hasAttr(String attributeKey) {
        for (Element element2 : this.contents) {
            if (!element2.hasAttr(attributeKey)) continue;
            return true;
        }
        return false;
    }

    public Elements attr(String attributeKey, String attributeValue) {
        for (Element element2 : this.contents) {
            element2.attr(attributeKey, attributeValue);
        }
        return this;
    }

    public Elements removeAttr(String attributeKey) {
        for (Element element2 : this.contents) {
            element2.removeAttr(attributeKey);
        }
        return this;
    }

    public Elements addClass(String className) {
        for (Element element2 : this.contents) {
            element2.addClass(className);
        }
        return this;
    }

    public Elements removeClass(String className) {
        for (Element element2 : this.contents) {
            element2.removeClass(className);
        }
        return this;
    }

    public Elements toggleClass(String className) {
        for (Element element2 : this.contents) {
            element2.toggleClass(className);
        }
        return this;
    }

    public boolean hasClass(String className) {
        for (Element element2 : this.contents) {
            if (!element2.hasClass(className)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String value) {
        for (Element element2 : this.contents) {
            element2.val(value);
        }
        return this;
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Element element2 : this.contents) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(element2.text());
        }
        return sb.toString();
    }

    public boolean hasText() {
        for (Element element2 : this.contents) {
            if (!element2.hasText()) continue;
            return true;
        }
        return false;
    }

    public String html() {
        StringBuilder sb = new StringBuilder();
        for (Element element2 : this.contents) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element2.html());
        }
        return sb.toString();
    }

    public String outerHtml() {
        StringBuilder sb = new StringBuilder();
        for (Element element2 : this.contents) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element2.outerHtml());
        }
        return sb.toString();
    }

    public String toString() {
        return this.outerHtml();
    }

    public Elements tagName(String tagName) {
        for (Element element2 : this.contents) {
            element2.tagName(tagName);
        }
        return this;
    }

    public Elements html(String html) {
        for (Element element2 : this.contents) {
            element2.html(html);
        }
        return this;
    }

    public Elements prepend(String html) {
        for (Element element2 : this.contents) {
            element2.prepend(html);
        }
        return this;
    }

    public Elements append(String html) {
        for (Element element2 : this.contents) {
            element2.append(html);
        }
        return this;
    }

    public Elements before(String html) {
        for (Element element2 : this.contents) {
            element2.before(html);
        }
        return this;
    }

    public Elements after(String html) {
        for (Element element2 : this.contents) {
            element2.after(html);
        }
        return this;
    }

    public Elements wrap(String html) {
        Validate.notEmpty(html);
        for (Element element2 : this.contents) {
            element2.wrap(html);
        }
        return this;
    }

    public Elements unwrap() {
        for (Element element2 : this.contents) {
            element2.unwrap();
        }
        return this;
    }

    public Elements empty() {
        for (Element element2 : this.contents) {
            element2.empty();
        }
        return this;
    }

    public Elements remove() {
        for (Element element2 : this.contents) {
            element2.remove();
        }
        return this;
    }

    public Elements select(String query2) {
        return Selector.select(query2, this);
    }

    public Elements not(String query2) {
        Elements out = Selector.select(query2, this);
        return Selector.filterOut(this, out);
    }

    public Elements eq(int index) {
        return this.contents.size() > index ? new Elements(this.get(index)) : new Elements();
    }

    public boolean is(String query2) {
        Elements children = this.select(query2);
        return !children.isEmpty();
    }

    public Elements parents() {
        LinkedHashSet<Element> combo = new LinkedHashSet<Element>();
        for (Element e : this.contents) {
            combo.addAll(e.parents());
        }
        return new Elements(combo);
    }

    public Element first() {
        return this.contents.isEmpty() ? null : this.contents.get(0);
    }

    public Element last() {
        return this.contents.isEmpty() ? null : this.contents.get(this.contents.size() - 1);
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor traversor = new NodeTraversor(nodeVisitor);
        for (Element el : this.contents) {
            traversor.traverse(el);
        }
        return this;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.contents.contains(o);
    }

    @Override
    public Iterator<Element> iterator() {
        return this.contents.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.contents.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.contents.toArray(a);
    }

    @Override
    public boolean add(Element element2) {
        return this.contents.add(element2);
    }

    @Override
    public boolean remove(Object o) {
        return this.contents.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.contents.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Element> c) {
        return this.contents.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Element> c) {
        return this.contents.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.contents.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.contents.retainAll(c);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.contents).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.contents).hashCode();
    }

    @Override
    public Element get(int index) {
        return this.contents.get(index);
    }

    @Override
    public Element set(int index, Element element2) {
        return this.contents.set(index, element2);
    }

    @Override
    public void add(int index, Element element2) {
        this.contents.add(index, element2);
    }

    @Override
    public Element remove(int index) {
        return this.contents.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.contents.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.contents.lastIndexOf(o);
    }

    @Override
    public ListIterator<Element> listIterator() {
        return this.contents.listIterator();
    }

    @Override
    public ListIterator<Element> listIterator(int index) {
        return this.contents.listIterator(index);
    }

    @Override
    public List<Element> subList(int fromIndex, int toIndex) {
        return this.contents.subList(fromIndex, toIndex);
    }
}

