/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.Iterator;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TreeBuilder;

public class XmlTreeBuilder
extends TreeBuilder {
    protected void initialiseParse(String input2, String baseUri, ParseErrorList errors) {
        super.initialiseParse(input2, baseUri, errors);
        this.stack.add(this.doc);
    }

    protected boolean process(Token token) {
        switch (token.type) {
            case StartTag: {
                this.insert(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insert(token.asComment());
                break;
            }
            case Character: {
                this.insert(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insert(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                Validate.fail("Unexpected token type: " + (Object)((Object)token.type));
            }
        }
        return true;
    }

    private void insertNode(Node node) {
        this.currentElement().appendChild(node);
    }

    Element insert(Token.StartTag startTag2) {
        Tag tag = Tag.valueOf(startTag2.name());
        Element el = new Element(tag, this.baseUri, startTag2.attributes);
        this.insertNode(el);
        if (startTag2.isSelfClosing()) {
            this.tokeniser.acknowledgeSelfClosingFlag();
            if (!tag.isKnownTag()) {
                tag.setSelfClosing();
            }
        } else {
            this.stack.add(el);
        }
        return el;
    }

    void insert(Token.Comment commentToken) {
        Comment comment = new Comment(commentToken.getData(), this.baseUri);
        this.insertNode(comment);
    }

    void insert(Token.Character characterToken) {
        TextNode node = new TextNode(characterToken.getData(), this.baseUri);
        this.insertNode(node);
    }

    void insert(Token.Doctype d) {
        DocumentType doctypeNode = new DocumentType(d.getName(), d.getPublicIdentifier(), d.getSystemIdentifier(), this.baseUri);
        this.insertNode(doctypeNode);
    }

    private void popStackToClose(Token.EndTag endTag2) {
        Element next2;
        String elName = endTag2.name();
        Element firstFound = null;
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next2 = (Element)it.next();
            if (!next2.nodeName().equals(elName)) continue;
            firstFound = next2;
            break;
        }
        if (firstFound == null) {
            return;
        }
        it = this.stack.descendingIterator();
        while (it.hasNext()) {
            next2 = (Element)it.next();
            if (next2 == firstFound) {
                it.remove();
                break;
            }
            it.remove();
        }
    }
}

