/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.DescendableLinkedList;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Token;
import org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected DescendableLinkedList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;

    TreeBuilder() {
    }

    protected void initialiseParse(String input2, String baseUri, ParseErrorList errors) {
        Validate.notNull(input2, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.reader = new CharacterReader(input2);
        this.errors = errors;
        this.tokeniser = new Tokeniser(this.reader, errors);
        this.stack = new DescendableLinkedList();
        this.baseUri = baseUri;
    }

    Document parse(String input2, String baseUri) {
        return this.parse(input2, baseUri, ParseErrorList.noTracking());
    }

    Document parse(String input2, String baseUri, ParseErrorList errors) {
        this.initialiseParse(input2, baseUri, errors);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected Element currentElement() {
        return (Element)this.stack.getLast();
    }
}

