/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.examples;

import java.io.IOException;
import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainText {
    public static void main(String ... args) throws IOException {
        Validate.isTrue(args.length == 1, "usage: supply url to fetch");
        String url = args[0];
        Document doc = Jsoup.connect(url).get();
        HtmlToPlainText formatter = new HtmlToPlainText();
        String plainText = formatter.getPlainText(doc);
        System.out.println(plainText);
    }

    public String getPlainText(Element element2) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor traversor = new NodeTraversor(formatter);
        traversor.traverse(element2);
        return formatter.toString();
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name2 = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name2.equals("li")) {
                this.append("\n * ");
            }
        }

        public void tail(Node node, int depth) {
            String name2 = node.nodeName();
            if (name2.equals("br")) {
                this.append("\n");
            } else if (StringUtil.in(name2, "p", "h1", "h2", "h3", "h4", "h5")) {
                this.append("\n\n");
            } else if (name2.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void append(String text2) {
            if (text2.startsWith("\n")) {
                this.width = 0;
            }
            if (text2.equals(" ") && (this.accum.length() == 0 || StringUtil.in(this.accum.substring(this.accum.length() - 1), " ", "\n"))) {
                return;
            }
            if (text2.length() + this.width > 80) {
                String[] words = text2.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    boolean last2;
                    String word = words[i];
                    boolean bl = last2 = i == words.length - 1;
                    if (!last2) {
                        word = word + " ";
                    }
                    if (word.length() + this.width > 80) {
                        this.accum.append("\n").append(word);
                        this.width = word.length();
                        continue;
                    }
                    this.accum.append(word);
                    this.width += word.length();
                }
            } else {
                this.accum.append(text2);
                this.width += text2.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

