/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamUtils {
    public static boolean isStartElement(XMLStreamReader reader2, String uri2, String name2) {
        return XMLStreamUtils.isElement(reader2, 1, uri2, name2);
    }

    public static boolean isEndElement(XMLStreamReader reader2, String uri2, String name2) {
        return XMLStreamUtils.isElement(reader2, 2, uri2, name2);
    }

    private static boolean isElement(XMLStreamReader reader2, int event, String uri2, String name2) {
        String found;
        if (reader2.getEventType() != event) {
            return false;
        }
        if (uri2 != null && !(found = reader2.getNamespaceURI()).equals(uri2)) {
            return false;
        }
        return name2 == null || (found = reader2.getLocalName()).equals(name2);
    }

    public static void requireStartElement(XMLStreamReader reader2, String uri2, String name2) throws XMLStreamException {
        XMLStreamUtils.requireElement(reader2, 1, uri2, name2, "");
    }

    public static void requireEndElement(XMLStreamReader reader2, String uri2, String name2) throws XMLStreamException {
        XMLStreamUtils.requireElement(reader2, 2, uri2, name2, "/");
    }

    private static void requireElement(XMLStreamReader reader2, int event, String uri2, String name2, String slash) throws XMLStreamException {
        String found;
        if (reader2.getEventType() != event) {
            throw new XMLStreamException("expected <" + slash + name2 + ">", reader2.getLocation());
        }
        if (uri2 != null && !(found = reader2.getNamespaceURI()).equals(uri2)) {
            throw new XMLStreamException("expected <" + slash + name2 + "> with namespace [" + uri2 + "], found [" + found + "]", reader2.getLocation());
        }
        if (name2 != null && !(found = reader2.getLocalName()).equals(name2)) {
            throw new XMLStreamException("expected <" + slash + name2 + ">, found <" + slash + found + ">", reader2.getLocation());
        }
    }

    public static void skipElement(XMLStreamReader reader2) throws XMLStreamException {
        if (reader2.getEventType() != 1) {
            throw new XMLStreamException("expected start of element", reader2.getLocation());
        }
        int depth = 0;
        while (reader2.hasNext()) {
            int event = reader2.next();
            if (event == 1) {
                ++depth;
                continue;
            }
            if (event != 2 || --depth != -1) continue;
            break;
        }
    }

    public static String requireAttr(XMLStreamReader reader2, String elem, String attr2) throws XMLStreamException {
        String str = reader2.getAttributeValue(null, attr2);
        if (str == null || str.length() == 0) {
            throw new XMLStreamException("expected non-empty attribute [" + attr2 + "] on element [" + elem + "]", reader2.getLocation());
        }
        return str;
    }
}

