/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util.text.html;

public enum XmlCodes {
    NONE(false, false, false),
    AMP(true, false, false),
    BRA(false, true, false),
    QUO(false, false, true),
    BRA_QUO(false, true, true),
    AMP_QUO(true, false, true),
    AMP_BRA(true, true, false),
    AMP_BRA_QUO(true, true, true);

    private final String[] _codes = new String[64];

    public static XmlCodes choose(boolean amp2, boolean bra, boolean quo) {
        return amp2 ? (bra ? (quo ? AMP_BRA_QUO : AMP_BRA) : (quo ? AMP_QUO : AMP)) : (bra ? (quo ? BRA_QUO : BRA) : (quo ? QUO : NONE));
    }

    private XmlCodes(boolean amp2, boolean brackets, boolean quotes) {
        if (amp2) {
            this._codes[38] = "&amp;";
        }
        if (brackets) {
            this._codes[60] = "&lt;";
            this._codes[62] = "&gt;";
        }
        if (quotes) {
            this._codes[34] = "&quot;";
            this._codes[39] = "&apos;";
        }
    }

    public String encode(int code) {
        return code >= 64 ? null : this._codes[code];
    }
}

