/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Exceptions {
    public static Throwable getRootCause(Throwable error) {
        Throwable cause = error;
        while (cause != null) {
            error = cause;
            cause = error.getCause();
        }
        return error;
    }

    public static <T extends Throwable> T initCause(T exception, Throwable cause) {
        Throwable result2 = exception.initCause(cause);
        return (T)result2;
    }

    public static RuntimeException unchecked(Throwable exception, Throwable cause) {
        Exceptions.cheat(exception.initCause(cause));
        return null;
    }

    public static RuntimeException unchecked(Throwable exception) {
        Exceptions.cheat(exception);
        return null;
    }

    private static <T extends Throwable> void cheat(Throwable throwable) throws T {
        Throwable result2 = throwable;
        throw result2;
    }

    public static String getStackTrace(Throwable error) {
        StringWriter writer2 = new StringWriter();
        PrintWriter printer = new PrintWriter(writer2);
        error.printStackTrace(printer);
        printer.close();
        return writer2.toString();
    }

    public static String getStackTrace(Throwable error, int depth) {
        return Exceptions.getStackTrace(null, error, depth);
    }

    public static String getStackTrace(Object message, Throwable error, int depth) {
        StringWriter writer2 = new StringWriter();
        PrintWriter printer = new PrintWriter(writer2);
        Exceptions.printStackTrace(message, error, depth, printer);
        printer.close();
        return writer2.toString();
    }

    public static void printStackTrace(Throwable error, int depth, PrintWriter stream) {
        Exceptions.printStackTrace(null, error, depth, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Object message, Throwable error, int depth, PrintWriter stream) {
        PrintWriter printWriter = stream;
        synchronized (printWriter) {
            if (message != null) {
                stream.println(message);
            }
            if (error == null) {
                return;
            }
            stream.println(error);
            StackTraceElement[] trace = error.getStackTrace();
            depth = Math.min(depth, trace.length);
            for (int i = 0; i < depth; ++i) {
                stream.println("\tat " + trace[i]);
            }
            if (trace.length > depth) {
                stream.println("\t... " + (trace.length - depth) + " more");
            }
        }
    }

    public static void printStackTrace(Throwable error, int depth, PrintStream stream) {
        Exceptions.printStackTrace(null, error, depth, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printStackTrace(Object message, Throwable error, int depth, PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            if (message != null) {
                stream.println(message);
            }
            if (error == null) {
                return;
            }
            stream.println(error);
            StackTraceElement[] trace = error.getStackTrace();
            depth = Math.min(depth, trace.length);
            for (int i = 0; i < depth; ++i) {
                stream.println("\tat " + trace[i]);
            }
            if (trace.length > depth) {
                stream.println("\t... " + (trace.length - depth) + " more");
            }
        }
    }

    public static String toString(Throwable ex, int max2) {
        String str = ex.toString();
        int len = str.length();
        if (len <= max2) {
            return str;
        }
        return str.substring(0, (max2 + 1) / 2) + " ..." + (len - max2) + " chars omitted... " + str.substring(len - max2 / 2);
    }
}

