/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.wikiparser.impl.json;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.dbpedia.extraction.sources.WikiPage;
import org.dbpedia.extraction.util.WikidataUtil$;
import org.dbpedia.extraction.wikiparser.JsonNode;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedStatementDocument;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E;Q!\u0001\u0002\t\u0002=\taBS:p]^K7.\u001b)beN,'O\u0003\u0002\u0004\t\u0005!!n]8o\u0015\t)a!\u0001\u0003j[Bd'BA\u0004\t\u0003)9\u0018n[5qCJ\u001cXM\u001d\u0006\u0003\u0013)\t!\"\u001a=ue\u0006\u001cG/[8o\u0015\tYA\"A\u0004eEB,G-[1\u000b\u00035\t1a\u001c:h\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011aBS:p]^K7.\u001b)beN,'o\u0005\u0002\u0012)A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001aDQaG\t\u0005\u0002q\ta\u0001P5oSRtD#A\b\t\u000fy\t\"\u0019!C\u0005?\u0005\tr+[6j\u0019\u0006tw-^1hKJ+w-\u001a=\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t1\fgn\u001a\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0004TiJLgn\u001a\u0005\u0007SE\u0001\u000b\u0011\u0002\u0011\u0002%]K7.\u001b'b]\u001e,\u0018mZ3SK\u001e,\u0007\u0010\t\u0004\u0005%\t\u00011f\u0005\u0002+)!)1D\u000bC\u0001[Q\ta\u0006\u0005\u0002\u0011U!)\u0001G\u000bC\u0001c\u0005)\u0011\r\u001d9msR\u0011!'\u000f\t\u0004+M*\u0014B\u0001\u001b\u0017\u0005\u0019y\u0005\u000f^5p]B\u0011agN\u0007\u0002\r%\u0011\u0001H\u0002\u0002\t\u0015N|gNT8eK\")!h\fa\u0001w\u0005!\u0001/Y4f!\tat(D\u0001>\u0015\tq\u0004\"A\u0004t_V\u00148-Z:\n\u0005\u0001k$\u0001C,jW&\u0004\u0016mZ3\t\u000b\tSC\u0011B\"\u0002%\u001d,GOS1dWN|g\u000eR8dk6,g\u000e\u001e\u000b\u0004e\u0011+\u0005\"\u0002\u001eB\u0001\u0004Y\u0004\"\u0002$B\u0001\u00049\u0015A\u00036t_:\u001cFO]5oOB\u0011\u0001j\u0013\b\u0003+%K!A\u0013\f\u0002\rA\u0013X\rZ3g\u0013\t9CJ\u0003\u0002K-!)aJ\u000bC\u0005\u001f\u0006ia-\u001b=Ce>\\WM\u001c&t_:$\"a\u0012)\t\u000b\u0019k\u0005\u0019A$")
public class JsonWikiParser {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<JsonNode> apply(WikiPage page) {
        Option option;
        if (page.format() != null) {
            String string2 = page.format();
            String string3 = "application/json";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                option = this.getJacksonDocument(page, page.source());
                return option;
            }
        }
        option = None$.MODULE$;
        return option;
        catch (JsonMappingException jsonMappingException) {
            if (page.redirect() == null) {
                option = this.getJacksonDocument(page, this.fixBrokenJson(page.source()));
                return option;
            }
            option = None$.MODULE$;
        }
        return option;
    }

    private Option<JsonNode> getJacksonDocument(WikiPage page, String jsonString) {
        ObjectMapper mapper = new ObjectMapper();
        JacksonTermedStatementDocument jacksonDocument = mapper.readValue(jsonString, JacksonTermedStatementDocument.class);
        jacksonDocument.setSiteIri(WikidataUtil$.MODULE$.wikidataDBpNamespace());
        return new Some<JsonNode>(new JsonNode(page, jacksonDocument));
    }

    private String fixBrokenJson(String jsonString) {
        return jsonString.replace("claims\":[]", "claims\":{}").replace("descriptions\":[]", "descriptions\":{}").replace("sitelinks\":[]", "sitelinks\":{}").replace("labels\":[]", "labels\":{}");
    }
}

