/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.StringUtils$;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueMonolingualText;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class WikidataUtil$ {
    public static final WikidataUtil$ MODULE$;
    private final String wikidataDBpNamespace;

    static {
        new WikidataUtil$();
    }

    public String replacePunctuation(String value, String lang) {
        return value.replace(new StringBuilder().append((Object)"(").append((Object)lang).append((Object)")").toString(), "").replace("[", "").replace("]", "").replace("\"", "").trim();
    }

    public String replacePunctuation$default$2() {
        return "";
    }

    public String replaceItemId(String item) {
        return item.replace("(item)", "").toString().trim();
    }

    public String replaceString(String str) {
        return str.replace("(String)", "").trim();
    }

    public String getItemId(Value value) {
        String string2;
        Value value2 = value;
        if (value2 instanceof ItemIdValue) {
            ItemIdValue itemIdValue = (ItemIdValue)value2;
            string2 = this.replaceItemId(itemIdValue.toString()).replace(this.wikidataDBpNamespace(), "");
        } else {
            string2 = new StringBuilder().append((Object)"V").append((Object)this.getHash(value)).toString();
        }
        return string2;
    }

    public String getStatementUri(String subject, String property, Value value) {
        return new StringBuilder().append((Object)subject).append((Object)"_").append((Object)property.replace(this.wikidataDBpNamespace(), "").trim()).append((Object)"_").append((Object)this.getItemId(value)).toString();
    }

    public String getHash(Value value) {
        String hash_string = value.toString();
        return StringUtils$.MODULE$.md5sum(hash_string).substring(0, 5);
    }

    public String getDatatype(Value value) {
        StringValue stringValue;
        Value value2 = value;
        String string2 = value2 instanceof ItemIdValue ? null : (value2 instanceof StringValue ? ((stringValue = (StringValue)value2).toString().contains("http://") || stringValue.toString().contains("https://") ? null : "xsd:string") : (value2 instanceof TimeValue ? "xsd:date" : (value2 instanceof GlobeCoordinatesValue ? "xsd:string" : (value2 instanceof QuantityValue ? "xsd:float" : (value2 instanceof JacksonValueMonolingualText ? "xsd:string" : null)))));
        return string2;
    }

    public String getValue(Value value) {
        String string2;
        Value value2 = value;
        if (value2 instanceof ItemIdValue) {
            ItemIdValue itemIdValue = (ItemIdValue)value2;
            string2 = this.replaceItemId(itemIdValue.toString());
        } else if (value2 instanceof StringValue) {
            StringValue stringValue = (StringValue)value2;
            string2 = this.replacePunctuation(this.replaceString(stringValue.toString()), this.replacePunctuation$default$2());
        } else if (value2 instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)value2;
            string2 = new StringBuilder().append(timeValue.getYear()).append((Object)"-").append(BoxesRunTime.boxToByte(timeValue.getMonth())).append((Object)"-").append(BoxesRunTime.boxToByte(timeValue.getDay())).toString();
        } else if (value2 instanceof GlobeCoordinatesValue) {
            GlobeCoordinatesValue globeCoordinatesValue = (GlobeCoordinatesValue)value2;
            string2 = new StringBuilder().append(globeCoordinatesValue.getLatitude()).append((Object)" ").append(BoxesRunTime.boxToDouble(globeCoordinatesValue.getLongitude())).toString();
        } else if (value2 instanceof QuantityValue) {
            QuantityValue quantityValue = (QuantityValue)value2;
            string2 = quantityValue.getNumericValue().toString();
        } else if (value2 instanceof JacksonValueMonolingualText) {
            JacksonValueMonolingualText jacksonValueMonolingualText = (JacksonValueMonolingualText)value2;
            string2 = jacksonValueMonolingualText.getText();
        } else if (value2 instanceof PropertyIdValue) {
            PropertyIdValue propertyIdValue = (PropertyIdValue)value2;
            string2 = this.getWikidataNamespace(propertyIdValue.getIri());
        } else {
            string2 = value.toString();
        }
        return string2;
    }

    public String getWikidataNamespace(String namespace) {
        return namespace.replace(this.wikidataDBpNamespace(), "http://wikidata.org/entity/");
    }

    public String wikidataDBpNamespace() {
        return this.wikidataDBpNamespace;
    }

    private WikidataUtil$() {
        MODULE$ = this;
        this.wikidataDBpNamespace = Language$.MODULE$.apply("wikidata").resourceUri().namespace();
    }
}

