/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import org.dbpedia.extraction.util.RichString$;
import org.dbpedia.extraction.util.StringUtils$;
import org.dbpedia.util.text.uri.UriDecoder;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class WikiUtil$ {
    public static final WikiUtil$ MODULE$;
    private final String[] replacements;
    private final Regex wikiEmphasisRegex1;
    private final Regex wikiEmphasisRegex2;
    private final Regex wikiEmphasisRegex3;

    static {
        new WikiUtil$();
    }

    public String cleanSpace(String string2) {
        return RichString$.MODULE$.wrapString(string2).replaceChars("_\u00a0\u200e\u200f\u2028\u202a\u202b\u202c\u3000", "  ").replaceAll(" +", " ").trim();
    }

    public String[] iriReplacements() {
        return StringUtils$.MODULE$.replacements('%', "\"#%<>?[\\]^`{|}", StringUtils$.MODULE$.replacements$default$3());
    }

    private String[] replacements() {
        return this.replacements;
    }

    public String wikiEncode(String name2) {
        String encoded = name2.replace(' ', '_');
        encoded = encoded.replaceAll("_+", "_");
        encoded = encoded.replaceAll("^_", "");
        encoded = encoded.replaceAll("_$", "");
        return StringUtils$.MODULE$.escape(encoded, this.replacements());
    }

    public String wikiDecode(String name2) {
        return this.cleanSpace(UriDecoder.decode(name2));
    }

    private Regex wikiEmphasisRegex1() {
        return this.wikiEmphasisRegex1;
    }

    private Regex wikiEmphasisRegex2() {
        return this.wikiEmphasisRegex2;
    }

    private Regex wikiEmphasisRegex3() {
        return this.wikiEmphasisRegex3;
    }

    /*
     * WARNING - void declaration
     */
    public String removeWikiEmphasis(String text2) {
        void var2_2;
        String result2 = this.wikiEmphasisRegex1().replaceAllIn((CharSequence)text2, "$1");
        result2 = this.wikiEmphasisRegex2().replaceAllIn((CharSequence)result2, "$1");
        result2 = this.wikiEmphasisRegex3().replaceAllIn((CharSequence)result2, "$1");
        return var2_2;
    }

    private WikiUtil$() {
        MODULE$ = this;
        this.replacements = this.iriReplacements();
        this.wikiEmphasisRegex1 = new StringOps(Predef$.MODULE$.augmentString("(?s)'''''(.*?)'''''")).r();
        this.wikiEmphasisRegex2 = new StringOps(Predef$.MODULE$.augmentString("(?s)'''(.*?)'''")).r();
        this.wikiEmphasisRegex3 = new StringOps(Predef$.MODULE$.augmentString("(?s)''(.*?)''")).r();
    }
}

