/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.io.Serializable;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.dbpedia.extraction.util.NumberUtils$;
import scala.Array$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.Ordering$Char$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class StringUtils$ {
    public static final StringUtils$ MODULE$;
    private final ThreadLocal<DateFormat> timestampFormat;
    private final String zeros;

    static {
        new StringUtils$();
    }

    private ThreadLocal<DateFormat> timestampFormat() {
        return this.timestampFormat;
    }

    public String formatCurrentTimestamp() {
        return this.formatTimestamp(System.currentTimeMillis());
    }

    public String formatTimestamp(long timestamp) {
        return timestamp < 0L ? "" : ((Format)this.timestampFormat().get()).format(BoxesRunTime.boxToLong(timestamp));
    }

    public long parseTimestamp(String str) {
        return str == null || str.isEmpty() ? -1L : this.timestampFormat().get().parse(str).getTime();
    }

    public String prettyMillis(long millis) {
        return new scala.collection.mutable.StringBuilder().append((Object)this.zeros(2, millis / 60000L)).append(BoxesRunTime.boxToCharacter(':')).append((Object)this.zeros(2, millis % 60000L / 1000L)).append(BoxesRunTime.boxToCharacter('.')).append((Object)this.zeros(3, millis % 1000L)).append(BoxesRunTime.boxToCharacter('s')).toString();
    }

    private String zeros() {
        return this.zeros;
    }

    private String zeros(int z, long n) {
        int p = 10;
        for (int e = 1; e < z; ++e) {
            if (n < (long)p) {
                return new scala.collection.mutable.StringBuilder().append((Object)this.zeros().substring(0, z - e)).append(BoxesRunTime.boxToLong(n)).toString();
            }
            p *= 10;
        }
        return ((Object)BoxesRunTime.boxToLong(n)).toString();
    }

    public StringBuilder escape(StringBuilder target, String str, char esc, String replace) {
        ObjectRef<StringBuilder> sb = ObjectRef.create(target);
        char[] chars = str.toCharArray();
        int last2 = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            Serializable serializable;
            char c = chars[pos];
            if (replace.indexOf(c) != -1) {
                if ((StringBuilder)sb.elem == null) {
                    sb.elem = new StringBuilder();
                }
                ((StringBuilder)sb.elem).append(chars, last2, pos - last2);
                last2 = pos + 1;
                if (c < '\u0080') {
                    ((StringBuilder)sb.elem).append(esc);
                    serializable = NumberUtils$.MODULE$.intToHex((StringBuilder)sb.elem, c, 2);
                    continue;
                }
                byte[] bytes = new String(new char[]{c}).getBytes("UTF-8");
                Predef$.MODULE$.byteArrayOps(bytes).foreach(new scala.Serializable(esc, sb){
                    private final char esc$1;
                    private final ObjectRef sb$1;

                    public final StringBuilder apply(byte b) {
                        ((StringBuilder)this.sb$1.elem).append(this.esc$1);
                        return NumberUtils$.MODULE$.intToHex((StringBuilder)this.sb$1.elem, b, 2);
                    }
                    {
                        this.esc$1 = esc$1;
                        this.sb$1 = sb$1;
                    }
                });
                serializable = BoxedUnit.UNIT;
                continue;
            }
            serializable = BoxedUnit.UNIT;
        }
        Serializable serializable = (StringBuilder)sb.elem == null ? BoxedUnit.UNIT : ((StringBuilder)sb.elem).append(chars, last2, chars.length - last2);
        return (StringBuilder)sb.elem;
    }

    public String[] replacements(char esc, String chars, int limit) {
        String[] stringArray;
        if (chars.isEmpty()) {
            stringArray = new String[]{};
        } else {
            char max2 = BoxesRunTime.unboxToChar(new StringOps(Predef$.MODULE$.augmentString(chars)).max((Ordering)Ordering$Char$.MODULE$));
            if (max2 >= limit) {
                throw new IllegalArgumentException(new scala.collection.mutable.StringBuilder().append((Object)"highest code point ").append(BoxesRunTime.boxToInteger(max2)).append((Object)" exceeds limit ").append(BoxesRunTime.boxToInteger(limit)).toString());
            }
            String[] replace = new String[max2 + '\u0001'];
            for (int pos = 0; pos < chars.length(); ++pos) {
                Serializable serializable;
                char c = chars.charAt(pos);
                StringBuilder sb = new StringBuilder();
                if (c < '\u0080') {
                    sb.append(esc);
                    serializable = NumberUtils$.MODULE$.intToHex(sb, c, 2);
                } else {
                    byte[] bytes = new String(new char[]{c}).getBytes("UTF-8");
                    Predef$.MODULE$.byteArrayOps(bytes).foreach(new scala.Serializable(esc, sb){
                        private final char esc$2;
                        private final StringBuilder sb$2;

                        public final StringBuilder apply(byte b) {
                            this.sb$2.append(this.esc$2);
                            return NumberUtils$.MODULE$.intToHex(this.sb$2, b, 2);
                        }
                        {
                            this.esc$2 = esc$2;
                            this.sb$2 = sb$2;
                        }
                    });
                    serializable = BoxedUnit.UNIT;
                }
                replace[c] = sb.toString();
            }
            stringArray = replace;
        }
        return stringArray;
    }

    public int replacements$default$3() {
        return 256;
    }

    public String escape(String input2, String[] replace) {
        StringBuilder sb = this.escape(null, input2, replace);
        return sb == null ? input2 : sb.toString();
    }

    public StringBuilder escape(StringBuilder target, String str, String[] replace) {
        StringBuilder sb = target;
        char[] chars = str.toCharArray();
        int last2 = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            Serializable serializable;
            char c = chars[pos];
            if (c < replace.length) {
                String rep = replace[c];
                if (rep == null) {
                    serializable = BoxedUnit.UNIT;
                    continue;
                }
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(chars, last2, pos - last2);
                last2 = pos + 1;
                serializable = sb.append(rep);
                continue;
            }
            serializable = BoxedUnit.UNIT;
        }
        Serializable serializable = sb == null ? BoxedUnit.UNIT : sb.append(chars, last2, chars.length - last2);
        return sb;
    }

    public StringBuilder replaceChars(StringBuilder target, String str, String replace, String by2) {
        StringBuilder sb = target;
        char[] chars = str.toCharArray();
        int last2 = 0;
        for (int pos = 0; pos < chars.length; ++pos) {
            char ch = chars[pos];
            int index = replace.indexOf(ch);
            if (index == -1) continue;
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append(chars, last2, pos - last2);
            Serializable serializable = index < by2.length() ? sb.append(by2.charAt(index)) : BoxedUnit.UNIT;
            last2 = pos + 1;
        }
        Serializable serializable = sb == null ? BoxedUnit.UNIT : sb.append(chars, last2, chars.length - last2);
        return sb;
    }

    public String md5sum(String input2) {
        byte[] inputBytes = input2.getBytes("UTF-8");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(inputBytes);
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.byteArrayOps(md5.digest()).map(new scala.Serializable(){

            public final int apply(byte x$1) {
                return 0xFF & x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).map(new scala.Serializable(){

            public final String apply(int x$2) {
                return new StringOps(Predef$.MODULE$.augmentString("%02x")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(x$2)}));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).foldLeft("", new scala.Serializable(){

            public final String apply(String x$3, String x$4) {
                return new scala.collection.mutable.StringBuilder().append((Object)x$3).append((Object)x$4).toString();
            }
        });
    }

    private StringUtils$() {
        MODULE$ = this;
        this.timestampFormat = new ThreadLocal<DateFormat>(){

            /*
             * WARNING - void declaration
             */
            public SimpleDateFormat initialValue() {
                void var1_1;
                SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
                format2.setTimeZone(TimeZone.getTimeZone("UTC"));
                return var1_1;
            }
        };
        this.zeros = "0000000000000000000000000";
    }
}

