/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.util;

import java.util.NoSuchElementException;
import java.util.Properties;
import org.dbpedia.extraction.mappings.Extractor;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.Language;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.wikiparser.Namespace;
import org.dbpedia.extraction.wikiparser.Namespace$;
import org.dbpedia.extraction.wikiparser.WikiTitle;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.StringBuilder;

public final class ExtractorUtils$ {
    public static final ExtractorUtils$ MODULE$;
    private final Set<Namespace> commonsNamespacesContainingMetadata;

    static {
        new ExtractorUtils$();
    }

    public Class<? extends Extractor<?>> loadExtractorClass(String name2) {
        String className = name2.startsWith(".") ? new StringBuilder().append((Object)Extractor.class.getPackage().getName()).append((Object)name2).toString() : name2;
        return Extractor.class.getClassLoader().loadClass(className).asSubclass(Extractor.class);
    }

    public Seq<Class<? extends Extractor<?>>> loadExtractorClassSeq(Seq<String> names2) {
        return names2 == null || names2.isEmpty() ? (Seq)Seq$.MODULE$.empty() : (Seq)names2.toList().map(new Serializable(){

            public final Class<? extends Extractor<?>> apply(String name2) {
                return ExtractorUtils$.MODULE$.loadExtractorClass(name2);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public Map<Language, Seq<Class<? extends Extractor<?>>>> loadExtractorsMapFromConfig(Seq<Language> languages, Properties config) {
        Seq<Class<? extends Extractor<?>>> stdExtractors = this.loadExtractorClassSeq(ConfigUtils$.MODULE$.getStrings(config, "extractors", ',', false));
        Map classes = ((TraversableOnce)languages.map(new Serializable(config, stdExtractors){
            private final Properties config$1;
            private final Seq stdExtractors$1;

            public final Tuple2<Language, Seq<Class<? extends Extractor<?>>>> apply(Language language2) {
                return new Tuple2<Language, Seq<Class<? extends Extractor<?>>>>(language2, (Seq<Class<? extends Extractor<?>>>)((SeqLike)this.stdExtractors$1.$plus$plus((GenTraversableOnce)ConfigUtils$.MODULE$.getStrings(this.config$1, new StringBuilder().append((Object)"extractors.").append((Object)language2.wikiCode()).toString(), ',', false).map(new Serializable(this){

                    public final Class<? extends Extractor<?>> apply(String name2) {
                        return ExtractorUtils$.MODULE$.loadExtractorClass(name2);
                    }
                }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct());
            }
            {
                this.config$1 = config$1;
                this.stdExtractors$1 = stdExtractors$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Map)SortedMap$.MODULE$.apply(classes.toSeq(), Language$.MODULE$.wikiCodeOrdering());
    }

    public Set<Namespace> commonsNamespacesContainingMetadata() {
        return this.commonsNamespacesContainingMetadata;
    }

    public boolean titleContainsCommonsMetadata(WikiTitle title) {
        Language language2 = title.language();
        Language language3 = Language$.MODULE$.Commons();
        return !(language2 != null ? !language2.equals(language3) : language3 != null) && this.commonsNamespacesContainingMetadata().contains(title.namespace());
    }

    public String getFileURL(String filename, Language language2) {
        return new StringBuilder().append((Object)language2.baseUri()).append((Object)"/wiki/Special:FilePath/").append((Object)filename).toString();
    }

    public String getThumbnailURL(String filename, Language language2) {
        return new StringBuilder().append((Object)language2.baseUri()).append((Object)"/wiki/Special:FilePath/").append((Object)filename).append((Object)"?width=300").toString();
    }

    private final Set liftedTree1$1() {
        try {
            return (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Namespace[]{Namespace$.MODULE$.Main(), Namespace$.MODULE$.File(), Namespace$.MODULE$.Category(), Namespace$.MODULE$.Template(), Namespace$.MODULE$.get(Language$.MODULE$.Commons(), "Creator").get(), Namespace$.MODULE$.get(Language$.MODULE$.Commons(), "Institution").get()}));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Commons namespace not correctly set up: make sure namespaces 'Creator' and 'Institution' are defined in settings/commonswiki-configuration.xml");
        }
    }

    private ExtractorUtils$() {
        MODULE$ = this;
        this.commonsNamespacesContainingMetadata = this.liftedTree1$1();
    }
}

