/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.mappings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dbpedia.extraction.mappings.Redirects;
import org.dbpedia.extraction.sources.Source;
import org.dbpedia.extraction.util.Language;
import scala.Predef$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Traversable$;
import scala.collection.mutable.StringBuilder;

public final class Redirects$ {
    public static final Redirects$ MODULE$;
    private final Logger logger;

    static {
        new Redirects$();
    }

    private Logger logger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Redirects load(Source source, File cache, Language lang) {
        try {
            return this.loadFromCache(cache);
        }
        catch (Exception exception) {
            this.logger().log(Level.INFO, new StringBuilder().append((Object)"Will extract redirects from source for ").append((Object)lang.wikiCode()).append((Object)" wiki, could not load cache file '").append(cache).append((Object)"': ").append(exception).toString());
            Redirects redirects = this.loadFromSource(source, lang);
            File dir = cache.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) void var6_6;
            throw new IOException(new StringBuilder().append((Object)"cache dir [").append(var6_6).append((Object)"] does not exist and cannot be created").toString());
            ObjectOutputStream outputStream2 = new ObjectOutputStream(new FileOutputStream(cache));
            try {
                outputStream2.writeObject(redirects.map());
            }
            catch (Throwable throwable) {
                void var7_7;
                var7_7.close();
                throw throwable;
            }
            outputStream2.close();
            this.logger().info(new StringBuilder().append(redirects.map().size()).append((Object)" redirects written to cache file ").append(cache).toString());
            return redirects;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Redirects loadFromCache(File cache) {
        Redirects redirects;
        this.logger().info(new StringBuilder().append((Object)"Loading redirects from cache file ").append(cache).toString());
        ObjectInputStream inputStream2 = new ObjectInputStream(new FileInputStream(cache));
        try {
            Redirects redirects2 = new Redirects((Map)inputStream2.readObject());
            this.logger().info(new StringBuilder().append(redirects2.map().size()).append((Object)" redirects loaded from cache file ").append(cache).toString());
            redirects = redirects2;
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        inputStream2.close();
        return redirects;
    }

    public Redirects loadFromSource(Source source, Language lang) {
        this.logger().info(new StringBuilder().append((Object)"Loading redirects from source (").append((Object)lang.wikiCode()).append((Object)")").toString());
        Redirects.RedirectFinder redirectFinder = new Redirects.RedirectFinder(lang);
        Redirects redirects = new Redirects(((TraversableOnce)source.flatMap(redirectFinder, Traversable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        this.logger().info(new StringBuilder().append((Object)"Redirects loaded from source (").append((Object)lang.wikiCode()).append((Object)")").toString());
        return redirects;
    }

    private Redirects$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(Redirects.class.getName());
    }
}

