/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.mappings;

import org.dbpedia.extraction.mappings.WiktionaryPageExtractor$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Matcher$ {
    public static final Matcher$ MODULE$;
    private final Regex cleaner;

    static {
        new Matcher$();
    }

    public float sim(String s1, String s2) {
        float f;
        if (s1.equals(s2)) {
            f = 1.0f;
        } else if (new StringOps(Predef$.MODULE$.augmentString(s1)).containsSlice(Predef$.MODULE$.wrapString(s2)) || new StringOps(Predef$.MODULE$.augmentString(s2)).containsSlice(Predef$.MODULE$.wrapString(s1))) {
            f = 0.9f;
        } else {
            String string2 = WiktionaryPageExtractor$.MODULE$.matchingStrategy();
            float f2 = "levenshtein".equals(string2) ? this.levenshtein(s1, s2) : ("dice".equals(string2) ? this.dice(this.ngrams(s1, 3), this.ngrams(s2, 3)) : ("jaccard".equals(string2) ? this.jaccard(this.ngrams(s1, 3), this.ngrams(s2, 3)) : ("overlap".equals(string2) ? this.overlap(this.ngrams(s1, 3), this.ngrams(s2, 3)) : this.levenshtein(s1, s2))));
            f = f2;
        }
        return f;
    }

    public Set<String> ngrams(String s2, int n) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("#")).$times(n - 1)).append((Object)s2).append((Object)new StringOps(Predef$.MODULE$.augmentString("#")).$times(n - 1)).toString())).sliding(n).toSet();
    }

    public float jaccard(Set<String> s1ngrams, Set<String> s2ngrams) {
        int intersectSize = ((TraversableOnce)s1ngrams.intersect(s2ngrams)).size();
        int unionSize = s1ngrams.union(s2ngrams).size();
        return unionSize == 0 ? 1.0f : (float)intersectSize / (float)unionSize;
    }

    public float dice(Set<String> s1ngrams, Set<String> s2ngrams) {
        int intersectSize = ((TraversableOnce)s1ngrams.intersect(s2ngrams)).size();
        int summedSize = s1ngrams.size() + s2ngrams.size();
        return summedSize == 0 ? 1.0f : (float)(2 * intersectSize) / (float)summedSize;
    }

    public float overlap(Set<String> s1ngrams, Set<String> s2ngrams) {
        int s2Size;
        int intersectSize = ((TraversableOnce)s1ngrams.intersect(s2ngrams)).size();
        int s1Size = s1ngrams.size();
        int minSize = s1Size < (s2Size = s2ngrams.size()) ? s1Size : s2Size;
        return minSize == 0 ? 0.0f : (float)intersectSize / (float)minSize;
    }

    public int levenshtein_dist(String s1, String s2) {
        Map memo = (Map)Map$.MODULE$.apply(Nil$.MODULE$);
        return this.sd$1(new StringOps(Predef$.MODULE$.augmentString(s1)).toList(), new StringOps(Predef$.MODULE$.augmentString(s2)).toList(), memo);
    }

    public float levenshtein(String s1, String s2) {
        int s1Size = new StringOps(Predef$.MODULE$.augmentString(s1)).size();
        int s2Size = new StringOps(Predef$.MODULE$.augmentString(s2)).size();
        return 1.0f - (float)this.levenshtein_dist(s1, s2) / (float)package$.MODULE$.max(s1Size, s2Size);
    }

    public Regex cleaner() {
        return this.cleaner;
    }

    public String clean(String in) {
        return this.cleaner().replaceAllIn((CharSequence)in.toLowerCase(), "");
    }

    private final int min$1(int a, int b, int c) {
        return package$.MODULE$.min(package$.MODULE$.min(a, b), c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int sd$1(List s1, List s2, Map memo$1) {
        List list;
        int n;
        List list2;
        if (memo$1.contains(new Tuple2<List, List>(s1, s2))) return BoxesRunTime.unboxToInt(memo$1.apply(new Tuple2<List, List>(s1, s2)));
        Tuple2<List, List> tuple2 = new Tuple2<List, List>(s1, s2);
        if (tuple2 != null && ((Object)Nil$.MODULE$).equals(list2 = tuple2._2())) {
            n = s1.length();
        } else if (tuple2 != null && ((Object)Nil$.MODULE$).equals(list = tuple2._1())) {
            n = s2.length();
        } else {
            if (tuple2 == null) throw new MatchError(tuple2);
            List list3 = tuple2._1();
            List list4 = tuple2._2();
            if (!(list3 instanceof $colon$colon)) throw new MatchError(tuple2);
            $colon$colon $colon$colon = ($colon$colon)list3;
            char c1 = BoxesRunTime.unboxToChar($colon$colon.head());
            List t1 = $colon$colon.tl$1();
            if (!(list4 instanceof $colon$colon)) throw new MatchError(tuple2);
            $colon$colon $colon$colon2 = ($colon$colon)list4;
            char c2 = BoxesRunTime.unboxToChar($colon$colon2.head());
            List t2 = $colon$colon2.tl$1();
            n = this.min$1(this.sd$1(t1, s2, memo$1) + 1, this.sd$1(s1, t2, memo$1) + 1, this.sd$1(t1, t2, memo$1) + (c1 == c2 ? 0 : 1));
        }
        memo$1.update(tuple2, BoxesRunTime.boxToInteger(n));
        return BoxesRunTime.unboxToInt(memo$1.apply(new Tuple2<List, List>(s1, s2)));
    }

    private Matcher$() {
        MODULE$ = this;
        this.cleaner = new StringOps(Predef$.MODULE$.augmentString("\\W")).r();
    }
}

