/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.mappings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dbpedia.extraction.mappings.Disambiguations;
import org.dbpedia.extraction.util.Language;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;

public final class Disambiguations$ {
    public static final Disambiguations$ MODULE$;
    private final Logger logger;

    static {
        new Disambiguations$();
    }

    private Logger logger() {
        return this.logger;
    }

    public Disambiguations empty() {
        return new Disambiguations((Set<Object>)Predef$.MODULE$.Set().empty());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Disambiguations load(Function0<Reader> reader2, File cache, Language lang) {
        try {
            return this.loadFromCache(cache);
        }
        catch (Exception exception) {
            this.logger().log(Level.INFO, new StringBuilder().append((Object)"Will extract disambiguations from source for ").append((Object)lang.wikiCode()).append((Object)" wiki, could not load cache file '").append(cache).append((Object)"': ").append(exception).toString());
            Disambiguations disambiguations = this.loadFromFile(reader2, lang);
            File dir = cache.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) void var6_6;
            throw new IOException(new StringBuilder().append((Object)"cache dir [").append(var6_6).append((Object)"] does not exist and cannot be created").toString());
            ObjectOutputStream outputStream2 = new ObjectOutputStream(new FileOutputStream(cache));
            try {
                outputStream2.writeObject(disambiguations.set());
            }
            catch (Throwable throwable) {
                void var7_7;
                var7_7.close();
                throw throwable;
            }
            outputStream2.close();
            this.logger().info(new StringBuilder().append(disambiguations.set().size()).append((Object)" disambiguations written to cache file ").append(cache).toString());
            return disambiguations;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Disambiguations loadFromCache(File cache) {
        Disambiguations disambiguations;
        this.logger().info(new StringBuilder().append((Object)"Loading disambiguations from cache file ").append(cache).toString());
        ObjectInputStream inputStream2 = new ObjectInputStream(new FileInputStream(cache));
        try {
            Disambiguations disambiguations2 = new Disambiguations((Set)inputStream2.readObject());
            this.logger().info(new StringBuilder().append(disambiguations2.set().size()).append((Object)" disambiguations loaded from cache file ").append(cache).toString());
            disambiguations = disambiguations2;
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        inputStream2.close();
        return disambiguations;
    }

    public Disambiguations loadFromFile(Function0<Reader> reader2, Language lang) {
        this.logger().info(new StringBuilder().append((Object)"Loading disambiguations from source (").append((Object)lang.wikiCode()).append((Object)")").toString());
        Disambiguations.DisambiguationsFinder disambiguationsFinder = new Disambiguations.DisambiguationsFinder(lang);
        Disambiguations disambiguations = new Disambiguations(disambiguationsFinder.apply(reader2));
        this.logger().info(new StringBuilder().append((Object)"Disambiguations loaded from source (").append((Object)lang.wikiCode()).append((Object)")").toString());
        return disambiguations;
    }

    private Disambiguations$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(Disambiguations.class.getName());
    }
}

