/*
 * Decompiled with CFR 0.152.
 */
package org.dbpedia.extraction.destinations.formatters;

import java.io.Serializable;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.dbpedia.extraction.destinations.formatters.Formatter;
import org.dbpedia.extraction.destinations.formatters.RDFJSONFormatter;
import org.dbpedia.extraction.destinations.formatters.TerseFormatter;
import org.dbpedia.extraction.destinations.formatters.TriXFormatter;
import org.dbpedia.extraction.destinations.formatters.UriPolicy$;
import org.dbpedia.extraction.util.ConfigUtils$;
import org.dbpedia.extraction.util.Language$;
import org.dbpedia.extraction.util.RichString$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.xml.Utility$;

public final class UriPolicy$ {
    public static final UriPolicy$ MODULE$;
    private final int SUBJECT;
    private final int PREDICATE;
    private final int OBJECT;
    private final int DATATYPE;
    private final int CONTEXT;
    private final int POSITIONS;
    private final int ALL;
    private final Map<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies;
    private final Map<String, Function1<Function1<URI, URI>[], Formatter>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters;
    private final int MAX_LENGTH;

    static {
        new UriPolicy$();
    }

    public int SUBJECT() {
        return this.SUBJECT;
    }

    public int PREDICATE() {
        return this.PREDICATE;
    }

    public int OBJECT() {
        return this.OBJECT;
    }

    public int DATATYPE() {
        return this.DATATYPE;
    }

    public int CONTEXT() {
        return this.CONTEXT;
    }

    public int POSITIONS() {
        return this.POSITIONS;
    }

    public int ALL() {
        return this.ALL;
    }

    public Map<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies() {
        return this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies;
    }

    public Map<String, Function1<Function1<URI, URI>[], Formatter>> org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters() {
        return this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters;
    }

    public Map<String, Formatter> parseFormats(Properties config, String uriPolicyPrefix, String formatPrefix) {
        Map<String, Function1<URI, URI>[]> policies = this.parsePolicies(config, uriPolicyPrefix);
        return this.parseFormats(config, formatPrefix, policies);
    }

    public Map<String, Formatter> parseFormats(Properties config, String prefix, Map<String, Function1<URI, URI>[]> policies) {
        String dottedPrefix = new StringBuilder().append((Object)prefix).append((Object)".").toString();
        HashMap<String, Formatter> formats = new HashMap<String, Formatter>();
        JavaConversions$.MODULE$.asScalaSet(config.stringPropertyNames()).foreach(new scala.Serializable(config, policies, dottedPrefix, formats){
            private final Properties config$2;
            public final Map policies$1;
            private final String dottedPrefix$1;
            private final HashMap formats$1;

            public final void apply(String key) {
                if (key.startsWith(this.dottedPrefix$1)) {
                    String suffix = key.substring(this.dottedPrefix$1.length());
                    Seq<String> settings = ConfigUtils$.MODULE$.getStrings(this.config$2, key, ';', true);
                    Predef$.MODULE$.require(settings.length() == 1 || settings.length() == 2, (Function0<Object>)((Object)new scala.Serializable(this, key){
                        private final String key$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"key '").append((Object)this.key$1).append((Object)"' must have one or two values separated by ';' - file format and optional uri policy name").toString();
                        }
                        {
                            this.key$1 = key$1;
                        }
                    }));
                    Function1 formatter = (Function1)((Object)UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters().getOrElse((String)settings.apply(false), new scala.Serializable(this, settings, key){
                        private final Seq settings$1;
                        private final String key$1;

                        public final Nothing$ apply() {
                            throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"first value for key '").append((Object)this.key$1).append((Object)"' is '").append(this.settings$1.apply(false)).append((Object)"' but must be one of ").append((Object)((TraversableOnce)UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters().keys().toSeq().sorted(Ordering$String$.MODULE$)).mkString("'", "','", "'")).toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                        }
                        {
                            this.settings$1 = settings$1;
                            this.key$1 = key$1;
                        }
                    }));
                    Function1[] policy = settings.length() == 1 ? null : (Function1[])this.policies$1.getOrElse(settings.apply(true), new scala.Serializable(this, settings, key){
                        private final /* synthetic */ anonfun.parseFormats.1 $outer;
                        private final Seq settings$1;
                        private final String key$1;

                        public final Nothing$ apply() {
                            throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"second value for key '").append((Object)this.key$1).append((Object)"' is '").append(this.settings$1.apply(true)).append((Object)"' but must be a configured uri-policy, i.e. one of ").append((Object)this.$outer.policies$1.keys().mkString("'", "','", "'")).toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.settings$1 = settings$1;
                            this.key$1 = key$1;
                        }
                    });
                    this.formats$1.update(suffix, formatter.apply(policy));
                }
            }
            {
                this.config$2 = config$2;
                this.policies$1 = policies$1;
                this.dottedPrefix$1 = dottedPrefix$1;
                this.formats$1 = formats$1;
            }
        });
        return formats;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Function1<URI, URI>[]> parsePolicies(Properties config, String prefix) {
        void var3_3;
        HashMap policies = new HashMap();
        JavaConversions$.MODULE$.asScalaSet(config.stringPropertyNames()).foreach(new scala.Serializable(config, prefix, policies){
            private final Properties config$1;
            private final String prefix$2;
            private final HashMap policies$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(String key) {
                if (!key.startsWith(this.prefix$2)) return;
                try {
                    this.policies$2.update(key, UriPolicy$.MODULE$.parsePolicy(this.config$1.getProperty(key)));
                    return;
                }
                catch (Exception exception) {
                    throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"invalid URI policy: '").append((Object)key).append((Object)"=").append((Object)this.config$1.getProperty(key)).append((Object)"'").toString(), exception);
                }
            }
            {
                this.config$1 = config$1;
                this.prefix$2 = prefix$2;
                this.policies$2 = policies$2;
            }
        });
        return var3_3;
    }

    public Function1<URI, URI>[] parsePolicy(String list) {
        ArrayBuffer[] entries = (ArrayBuffer[])Array$.MODULE$.fill(this.POSITIONS(), new scala.Serializable(){

            public final ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> apply() {
                return new ArrayBuffer<Tuple2<Object, Function1<URI, URI>>>();
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        Predef$.MODULE$.refArrayOps((Object[])RichString$.MODULE$.wrapString(list).trimSplit(';')).foreach(new scala.Serializable(entries){
            private final ArrayBuffer[] entries$1;

            public final Object apply(String policy) {
                String[] stringArray = RichString$.MODULE$.wrapString(policy).trimSplit(':');
                Option<IndexedSeq<T>> option = Array$.MODULE$.unapplySeq(stringArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                    Some some;
                    Tuple3 tuple3;
                    String name2 = (String)((SeqLike)option.get()).apply(0);
                    String languages = (String)((SeqLike)option.get()).apply(1);
                    Option<B> option2 = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies().get(name2);
                    if (option2 instanceof Some && (tuple3 = (Tuple3)(some = (Some)option2).x()) != null) {
                        Growable growable;
                        Object object;
                        int prio = BoxesRunTime.unboxToInt(tuple3._1());
                        int position = BoxesRunTime.unboxToInt(tuple3._2());
                        Function1 factory = (Function1)tuple3._3();
                        Function1<URI, Object> policyApplicable = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$parsePolicyApplicable(languages);
                        Tuple2<Integer, R> entry = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(prio)), factory.apply(policyApplicable));
                        if (position == UriPolicy$.MODULE$.ALL()) {
                            Predef$.MODULE$.refArrayOps((Object[])this.entries$1).foreach(new scala.Serializable(this, entry){
                                private final Tuple2 entry$1;

                                public final ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> apply(ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> x$10) {
                                    return x$10.$plus$eq((Object)this.entry$1);
                                }
                                {
                                    this.entry$1 = entry$1;
                                }
                            });
                            object = BoxedUnit.UNIT;
                        } else {
                            object = this.entries$1[position].$plus$eq(entry);
                        }
                        Growable growable2 = growable = object;
                        return growable2;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"unknown policy name '").append((Object)name2).append((Object)"' in '").append((Object)policy).append((Object)"'").toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
                    }
                    throw new MatchError(option2);
                }
                throw UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(new StringBuilder().append((Object)"invalid format in '").append((Object)policy).append((Object)"'").toString(), UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2());
            }
            {
                this.entries$1 = entries$1;
            }
        });
        ArrayBuffer[] ordered = (ArrayBuffer[])Predef$.MODULE$.refArrayOps((Object[])entries).map(new scala.Serializable(){

            public final ArrayBuffer<Function1<URI, URI>> apply(ArrayBuffer<Tuple2<Object, Function1<URI, URI>>> x$11) {
                return ((TraversableLike)x$11.sortBy((Function1)((Object)new scala.Serializable(this){

                    public final int apply(Tuple2<Object, Function1<URI, URI>> x$12) {
                        return x$12._1$mcI$sp();
                    }
                }), (Ordering)Ordering$Int$.MODULE$)).map(new scala.Serializable(this){

                    public final Function1<URI, URI> apply(Tuple2<Object, Function1<URI, URI>> x$13) {
                        return x$13._2();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ArrayBuffer.class)));
        Predef$.MODULE$.refArrayOps((Object[])ordered).foreach(new scala.Serializable(){

            public final Object apply(ArrayBuffer<Function1<URI, URI>> list) {
                return list.isEmpty() ? list.$plus$eq(new scala.Serializable(this){

                    public final URI apply(URI x) {
                        return Predef$.MODULE$.identity(x);
                    }
                }) : BoxedUnit.UNIT;
            }
        });
        return (Function1[])Predef$.MODULE$.refArrayOps((Object[])ordered).map(new scala.Serializable(){

            public final Function1<URI, URI> apply(ArrayBuffer<Function1<URI, URI>> x$14) {
                return x$14.reduceLeft(new scala.Serializable(this){

                    public final Function1<URI, URI> apply(Function1<URI, URI> x$15, Function1<URI, URI> x$16) {
                        return x$15.andThen(x$16);
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class)));
    }

    public Function1<URI, Object> org$dbpedia$extraction$destinations$formatters$UriPolicy$$parsePolicyApplicable(String languages) {
        scala.Serializable serializable;
        Set codes2 = Predef$.MODULE$.refArrayOps((Object[])RichString$.MODULE$.wrapString(languages).trimSplit(',')).toSet();
        if (codes2.apply("*") != false) {
            serializable = new scala.Serializable(){

                public final boolean apply(URI uri2) {
                    String host = uri2.getHost();
                    return host != null && (host.equals("dbpedia.org") || host.endsWith(".dbpedia.org"));
                }
            };
        } else {
            Set genericDomain = codes2.apply("-") != false ? (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dbpedia.org"})) : (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$);
            Set domains = (Set)((SetLike)((SetLike)codes2.filter(new scala.Serializable(){

                public final boolean apply(String x$17) {
                    String string2 = x$17;
                    String string3 = "-";
                    return string2 != null ? !string2.equals(string3) : string3 != null;
                }
            })).map(new scala.Serializable(){

                public final String apply(String x$18) {
                    return Language$.MODULE$.apply(x$18).dbpediaDomain();
                }
            }, Set$.MODULE$.canBuildFrom())).$plus$plus(genericDomain);
            serializable = new scala.Serializable(domains){
                private final Set domains$1;

                public final boolean apply(URI uri2) {
                    return (boolean)this.domains$1.apply(uri2.getHost());
                }
                {
                    this.domains$1 = domains$1;
                }
            };
        }
        return serializable;
    }

    public IllegalArgumentException org$dbpedia$extraction$destinations$formatters$UriPolicy$$error(String message, Throwable cause) {
        return new IllegalArgumentException(message, cause);
    }

    public Throwable org$dbpedia$extraction$destinations$formatters$UriPolicy$$error$default$2() {
        return null;
    }

    public Function1<URI, URI> uri(Function1<URI, Object> applicableTo) {
        return new scala.Serializable(applicableTo){
            private final Function1 applicableTo$2;

            public final URI apply(URI iri) {
                return BoxesRunTime.unboxToBoolean(this.applicableTo$2.apply(iri)) ? UriPolicy$.MODULE$.toUri(iri) : iri;
            }
            {
                this.applicableTo$2 = applicableTo$2;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI toUri(URI iri) {
        URI uRI;
        if (iri.getHost() == null && iri.getAuthority() != null) {
            try {
                int portIndex;
                String host = iri.getAuthority();
                String user = null;
                int port = -1;
                int userIndex = host.indexOf(64);
                if (userIndex >= 0) {
                    user = host.substring(0, userIndex);
                    host = host.replace(new StringBuilder().append((Object)user).append((Object)"@").toString(), "");
                }
                if ((portIndex = host.indexOf(58)) >= 0) {
                    port = Integer.parseInt(host.substring(portIndex + 1));
                    host = host.replace(new StringBuilder().append((Object)":").append(BoxesRunTime.boxToInteger(port)).toString(), "");
                }
                host = IDN.toASCII(host);
                uRI = new URI(this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(iri.getScheme(), user, host, port, iri.getPath(), iri.getQuery(), iri.getFragment()).toASCIIString());
                return uRI;
            }
            catch (Throwable throwable) {
                URI uRI2;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof NumberFormatException ? true : throwable2 instanceof IllegalArgumentException;
                if (!bl) throw throwable;
                uRI = uRI2 = new URI(iri.toASCIIString());
                return uRI;
            }
        } else {
            uRI = new URI(iri.toASCIIString());
            return uRI;
        }
    }

    public Function1<URI, URI> generic(Function1<URI, Object> applicableTo) {
        return new scala.Serializable(applicableTo){
            private final Function1 applicableTo$4;

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean(this.applicableTo$4.apply(iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = "dbpedia.org";
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.applicableTo$4 = applicableTo$4;
            }
        };
    }

    public int MAX_LENGTH() {
        return this.MAX_LENGTH;
    }

    public Function1<URI, URI> rejectLong(Function1<URI, Object> applicableTo) {
        return new scala.Serializable(applicableTo){
            private final Function1 applicableTo$1;

            public final URI apply(URI iri) {
                String str;
                if (BoxesRunTime.unboxToBoolean(this.applicableTo$1.apply(iri)) && (str = iri.toString()).length() > UriPolicy$.MODULE$.MAX_LENGTH()) {
                    throw new URISyntaxException(str, new StringBuilder().append((Object)"length ").append(BoxesRunTime.boxToInteger(str.length())).append((Object)" exceeds maximum ").append(BoxesRunTime.boxToInteger(UriPolicy$.MODULE$.MAX_LENGTH())).toString());
                }
                return iri;
            }
            {
                this.applicableTo$1 = applicableTo$1;
            }
        };
    }

    public Function1<URI, URI> xmlSafe(Function1<URI, Object> applicableTo) {
        return new scala.Serializable(applicableTo){
            private final Function1 applicableTo$3;

            public final URI apply(URI iri) {
                URI uRI;
                if (BoxesRunTime.unboxToBoolean(this.applicableTo$3.apply(iri))) {
                    String scheme = iri.getScheme();
                    String user = iri.getRawUserInfo();
                    String host = iri.getHost() == null && iri.getAuthority() != null ? iri.getAuthority() : iri.getHost();
                    int port = iri.getPort();
                    String path = iri.getRawPath();
                    String query2 = iri.getRawQuery();
                    String frag = iri.getRawFragment();
                    if (frag == null) {
                        if (query2 == null) {
                            path = path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty() ? UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(path) : "/_";
                        } else {
                            query2 = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(query2);
                        }
                    } else {
                        frag = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(frag);
                    }
                    uRI = UriPolicy$.MODULE$.org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(scheme, user, host, port, path, query2, frag);
                } else {
                    uRI = iri;
                }
                return uRI;
            }
            {
                this.applicableTo$3 = applicableTo$3;
            }
        };
    }

    public String org$dbpedia$extraction$destinations$formatters$UriPolicy$$xmlSafe(String tail) {
        int index = tail.length();
        while (index > 0) {
            if (--index >= 2 && tail.charAt(index - 2) == '%') {
                return new StringBuilder().append((Object)tail).append(BoxesRunTime.boxToCharacter('_')).toString();
            }
            char ch = tail.charAt(index);
            if (ch != ':' && Utility$.MODULE$.isNameChar(ch)) {
                if (!Utility$.MODULE$.isNameStart(ch)) continue;
                return tail;
            }
            return new StringBuilder().append((Object)tail).append(BoxesRunTime.boxToCharacter('_')).toString();
        }
        return new StringBuilder().append((Object)tail).append(BoxesRunTime.boxToCharacter('_')).toString();
    }

    public URI org$dbpedia$extraction$destinations$formatters$UriPolicy$$uri(String scheme, String user, String host, int port, String path, String query2, String frag) {
        Serializable serializable;
        StringBuilder sb = new StringBuilder();
        Serializable serializable2 = scheme == null ? BoxedUnit.UNIT : sb.append(scheme).append(':');
        if (host == null) {
            serializable = BoxedUnit.UNIT;
        } else {
            sb.append("//");
            Serializable serializable3 = user == null ? BoxedUnit.UNIT : sb.append(user).append('@');
            sb.append(host);
            serializable = port != -1 ? sb.append(':').append(port) : BoxedUnit.UNIT;
        }
        Serializable serializable4 = path == null ? BoxedUnit.UNIT : sb.append(path);
        Serializable serializable5 = query2 == null ? BoxedUnit.UNIT : sb.append('?').append(query2);
        Serializable serializable6 = frag == null ? BoxedUnit.UNIT : sb.append('#').append(frag);
        return new URI(sb.toString());
    }

    private UriPolicy$() {
        MODULE$ = this;
        this.SUBJECT = 0;
        this.PREDICATE = 1;
        this.OBJECT = 2;
        this.DATATYPE = 3;
        this.CONTEXT = 4;
        this.POSITIONS = 5;
        this.ALL = -1;
        Seq policies = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3<String, Integer, anonfun.1>("reject-long", BoxesRunTime.boxToInteger(1), new scala.Serializable(){

            public final Function1<URI, URI> apply(Function1<URI, Object> applicableTo) {
                return UriPolicy$.MODULE$.rejectLong(applicableTo);
            }
        }), new Tuple3<String, Integer, anonfun.2>("uri", BoxesRunTime.boxToInteger(2), new scala.Serializable(){

            public final Function1<URI, URI> apply(Function1<URI, Object> applicableTo) {
                return UriPolicy$.MODULE$.uri(applicableTo);
            }
        }), new Tuple3<String, Integer, anonfun.3>("xml-safe", BoxesRunTime.boxToInteger(3), new scala.Serializable(){

            public final Function1<URI, URI> apply(Function1<URI, Object> applicableTo) {
                return UriPolicy$.MODULE$.xmlSafe(applicableTo);
            }
        }), new Tuple3<String, Integer, anonfun.4>("generic", BoxesRunTime.boxToInteger(4), new scala.Serializable(){

            public final Function1<URI, URI> apply(Function1<URI, Object> applicableTo) {
                return UriPolicy$.MODULE$.generic(applicableTo);
            }
        })}));
        Seq positions = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2<String, Integer>("", BoxesRunTime.boxToInteger(this.ALL())), new Tuple2<String, Integer>("-subjects", BoxesRunTime.boxToInteger(this.SUBJECT())), new Tuple2<String, Integer>("-predicates", BoxesRunTime.boxToInteger(this.PREDICATE())), new Tuple2<String, Integer>("-objects", BoxesRunTime.boxToInteger(this.OBJECT())), new Tuple2<String, Integer>("-datatypes", BoxesRunTime.boxToInteger(this.DATATYPE())), new Tuple2<String, Integer>("-contexts", BoxesRunTime.boxToInteger(this.CONTEXT()))}));
        Seq product2 = policies.withFilter(new scala.Serializable(){

            public final boolean apply(Tuple3<String, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>> check$ifrefutable$1) {
                Tuple3<String, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>> tuple3 = check$ifrefutable$1;
                boolean bl = tuple3 != null;
                return bl;
            }
        }).flatMap(new scala.Serializable(positions){
            private final Seq positions$1;

            public final Seq<Tuple2<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>>> apply(Tuple3<String, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>> x$2) {
                Tuple3<String, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>> tuple3 = x$2;
                if (tuple3 != null) {
                    String prefix = tuple3._1();
                    int prio = BoxesRunTime.unboxToInt(tuple3._2());
                    Function1<Function1<URI, Object>, Function1<URI, URI>> factory = tuple3._3();
                    Seq<Tuple2<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>>> seq = this.positions$1.withFilter(new scala.Serializable(this){

                        public final boolean apply(Tuple2<String, Object> check$ifrefutable$2) {
                            Tuple2<String, Object> tuple2 = check$ifrefutable$2;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    }).map(new scala.Serializable(this, prefix, prio, factory){
                        private final String prefix$1;
                        private final int prio$1;
                        private final Function1 factory$1;

                        public final Tuple2<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> apply(Tuple2<String, Object> x$1) {
                            Tuple2<String, Object> tuple2 = x$1;
                            if (tuple2 != null) {
                                String suffix = tuple2._1();
                                int position = tuple2._2$mcI$sp();
                                Tuple2<String, Tuple3<Object, Object, Function1<Function1<URI, Object>, Function1<URI, URI>>>> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new StringBuilder().append((Object)this.prefix$1).append((Object)suffix).toString()), new Tuple3<Integer, Integer, Function1>(BoxesRunTime.boxToInteger(this.prio$1), BoxesRunTime.boxToInteger(position), this.factory$1));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.prefix$1 = prefix$1;
                            this.prio$1 = prio$1;
                            this.factory$1 = factory$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return seq;
                }
                throw new MatchError(tuple3);
            }
            {
                this.positions$1 = positions$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$policies = Predef$.MODULE$.locally(product2.toMap(Predef$.MODULE$.$conforms()));
        this.org$dbpedia$extraction$destinations$formatters$UriPolicy$$formatters = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("trix-triples"), new scala.Serializable(){

            public final TriXFormatter apply(Function1<URI, URI>[] x$3) {
                return new TriXFormatter(false, x$3);
            }
        }), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("trix-quads"), new scala.Serializable(){

            public final TriXFormatter apply(Function1<URI, URI>[] x$4) {
                return new TriXFormatter(true, x$4);
            }
        }), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("turtle-triples"), new scala.Serializable(){

            public final TerseFormatter apply(Function1<URI, URI>[] x$5) {
                return new TerseFormatter(false, true, x$5);
            }
        }), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("turtle-quads"), new scala.Serializable(){

            public final TerseFormatter apply(Function1<URI, URI>[] x$6) {
                return new TerseFormatter(true, true, x$6);
            }
        }), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("n-triples"), new scala.Serializable(){

            public final TerseFormatter apply(Function1<URI, URI>[] x$7) {
                return new TerseFormatter(false, false, x$7);
            }
        }), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("n-quads"), new scala.Serializable(){

            public final TerseFormatter apply(Function1<URI, URI>[] x$8) {
                return new TerseFormatter(true, false, x$8);
            }
        }), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("rdf-json"), new scala.Serializable(){

            public final RDFJSONFormatter apply(Function1<URI, URI>[] x$9) {
                return new RDFJSONFormatter(x$9);
            }
        })}));
        this.MAX_LENGTH = 500;
    }
}

