/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int count2) {
        return RandomStringUtils.random(count2, false, false);
    }

    public static String randomAscii(int count2) {
        return RandomStringUtils.random(count2, 32, 127, false, false);
    }

    public static String randomAlphabetic(int count2) {
        return RandomStringUtils.random(count2, true, false);
    }

    public static String randomAlphanumeric(int count2) {
        return RandomStringUtils.random(count2, true, true);
    }

    public static String randomNumeric(int count2) {
        return RandomStringUtils.random(count2, false, true);
    }

    public static String random(int count2, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count2, 0, 0, letters, numbers);
    }

    public static String random(int count2, int start2, int end, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count2, start2, end, letters, numbers, null, RANDOM);
    }

    public static String random(int count2, int start2, int end, boolean letters, boolean numbers, char[] chars) {
        return RandomStringUtils.random(count2, start2, end, letters, numbers, chars, RANDOM);
    }

    public static String random(int count2, int start2, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count2 == 0) {
            return "";
        }
        if (count2 < 0) {
            throw new IllegalArgumentException("Requested random string length " + count2 + " is less than 0.");
        }
        if (start2 == 0 && end == 0) {
            end = 123;
            start2 = 32;
            if (!letters && !numbers) {
                start2 = 0;
                end = Integer.MAX_VALUE;
            }
        }
        char[] buffer = new char[count2];
        int gap = end - start2;
        while (count2-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start2) : chars[random.nextInt(gap) + start2];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count2 == 0) {
                        ++count2;
                        continue;
                    }
                    buffer[count2] = ch;
                    buffer[--count2] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count2 == 0) {
                        ++count2;
                        continue;
                    }
                    buffer[count2] = (char)(56320 + random.nextInt(128));
                    buffer[--count2] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count2;
                    continue;
                }
                buffer[count2] = ch;
                continue;
            }
            ++count2;
        }
        return new String(buffer);
    }

    public static String random(int count2, String chars) {
        if (chars == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(count2, chars.toCharArray());
    }

    public static String random(int count2, char[] chars) {
        if (chars == null) {
            return RandomStringUtils.random(count2, 0, 0, false, false, null, RANDOM);
        }
        return RandomStringUtils.random(count2, 0, chars.length, false, false, chars, RANDOM);
    }
}

