/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.apache.commons.jxpath.ri.model.dom.NamespacePointer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMNamespaceIterator
implements NodeIterator {
    private NodePointer parent;
    private List attributes;
    private int position = 0;

    public DOMNamespaceIterator(NodePointer parent) {
        this.parent = parent;
        this.attributes = new ArrayList();
        this.collectNamespaces(this.attributes, (Node)parent.getNode());
    }

    private void collectNamespaces(List attributes, Node node) {
        Node parent = node.getParentNode();
        if (parent != null) {
            this.collectNamespaces(attributes, parent);
        }
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        }
        if (node.getNodeType() == 1) {
            NamedNodeMap map2 = node.getAttributes();
            int count2 = map2.getLength();
            for (int i = 0; i < count2; ++i) {
                Attr attr2 = (Attr)map2.item(i);
                String prefix = DOMNodePointer.getPrefix(attr2);
                String name2 = DOMNodePointer.getLocalName(attr2);
                if ((prefix == null || !prefix.equals("xmlns")) && (prefix != null || !name2.equals("xmlns"))) continue;
                attributes.add(attr2);
            }
        }
    }

    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        String prefix = "";
        Attr attr2 = (Attr)this.attributes.get(index);
        String name2 = attr2.getPrefix();
        if (name2 != null && name2.equals("xmlns")) {
            prefix = DOMNodePointer.getLocalName(attr2);
        }
        return new NamespacePointer(this.parent, prefix, attr2.getValue());
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }
}

