/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMAttributePointer;
import org.apache.commons.jxpath.ri.model.dom.DOMNodePointer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMAttributeIterator
implements NodeIterator {
    private NodePointer parent;
    private QName name;
    private List attributes;
    private int position = 0;

    public DOMAttributeIterator(NodePointer parent, QName name2) {
        this.parent = parent;
        this.name = name2;
        this.attributes = new ArrayList();
        Node node = (Node)parent.getNode();
        if (node.getNodeType() == 1) {
            String lname = name2.getName();
            if (!lname.equals("*")) {
                Attr attr2 = this.getAttribute((Element)node, name2);
                if (attr2 != null) {
                    this.attributes.add(attr2);
                }
            } else {
                NamedNodeMap map2 = node.getAttributes();
                int count2 = map2.getLength();
                for (int i = 0; i < count2; ++i) {
                    Attr attr3 = (Attr)map2.item(i);
                    if (!this.testAttr(attr3)) continue;
                    this.attributes.add(attr3);
                }
            }
        }
    }

    private boolean testAttr(Attr attr2) {
        String nodePrefix = DOMNodePointer.getPrefix(attr2);
        String nodeLocalName = DOMNodePointer.getLocalName(attr2);
        if (nodePrefix != null && nodePrefix.equals("xmlns")) {
            return false;
        }
        if (nodePrefix == null && nodeLocalName.equals("xmlns")) {
            return false;
        }
        String testLocalName = this.name.getName();
        if (testLocalName.equals("*") || testLocalName.equals(nodeLocalName)) {
            String testPrefix = this.name.getPrefix();
            if (testPrefix == null || DOMAttributeIterator.equalStrings(testPrefix, nodePrefix)) {
                return true;
            }
            if (nodePrefix == null) {
                return false;
            }
            return DOMAttributeIterator.equalStrings(this.parent.getNamespaceURI(testPrefix), this.parent.getNamespaceURI(nodePrefix));
        }
        return false;
    }

    private static boolean equalStrings(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    private Attr getAttribute(Element element2, QName name2) {
        String testPrefix = name2.getPrefix();
        String testNS = null;
        if (testPrefix != null) {
            testNS = this.parent.getNamespaceResolver().getNamespaceURI(testPrefix);
        }
        if (testNS != null) {
            Attr attr2 = element2.getAttributeNodeNS(testNS, name2.getName());
            if (attr2 != null) {
                return attr2;
            }
            NamedNodeMap nnm = element2.getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                attr2 = (Attr)nnm.item(i);
                if (!this.testAttr(attr2)) continue;
                return attr2;
            }
            return null;
        }
        return element2.getAttributeNode(name2.getName());
    }

    public NodePointer getNodePointer() {
        int index;
        if (this.position == 0) {
            if (!this.setPosition(1)) {
                return null;
            }
            this.position = 0;
        }
        if ((index = this.position - 1) < 0) {
            index = 0;
        }
        return new DOMAttributePointer(this.parent, (Attr)this.attributes.get(index));
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position >= 1 && position <= this.attributes.size();
    }
}

