/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class PropertyIterator
implements NodeIterator {
    private boolean empty = false;
    private boolean reverse;
    private String name;
    private int startIndex = 0;
    private boolean targetReady = false;
    private int position = 0;
    private PropertyPointer propertyNodePointer;
    private int startPropertyIndex;
    private boolean includeStart = false;

    public PropertyIterator(PropertyOwnerPointer pointer, String name2, boolean reverse2, NodePointer startWith) {
        this.propertyNodePointer = (PropertyPointer)pointer.getPropertyPointer().clone();
        this.name = name2;
        this.reverse = reverse2;
        this.includeStart = true;
        if (reverse2) {
            this.startPropertyIndex = Integer.MIN_VALUE;
            this.startIndex = -1;
        }
        if (startWith != null) {
            while (startWith != null && startWith.getImmediateParentPointer() != pointer) {
                startWith = startWith.getImmediateParentPointer();
            }
            if (startWith == null) {
                throw new JXPathException("PropertyIerator startWith parameter is not a child of the supplied parent");
            }
            this.startPropertyIndex = ((PropertyPointer)startWith).getPropertyIndex();
            this.startIndex = startWith.getIndex();
            if (this.startIndex == Integer.MIN_VALUE) {
                this.startIndex = 0;
            }
            this.includeStart = false;
            if (reverse2 && this.startIndex == -1) {
                this.includeStart = true;
            }
        }
    }

    protected NodePointer getPropertyPointer() {
        return this.propertyNodePointer;
    }

    public void reset() {
        this.position = 0;
        this.targetReady = false;
    }

    public NodePointer getNodePointer() {
        if (this.position == 0) {
            if (this.name != null) {
                if (!this.targetReady) {
                    this.prepareForIndividualProperty(this.name);
                }
                if (this.empty) {
                    return null;
                }
            } else {
                if (!this.setPosition(1)) {
                    return null;
                }
                this.reset();
            }
        }
        try {
            return this.propertyNodePointer.getValuePointer();
        }
        catch (Throwable ex) {
            NullPropertyPointer npp = new NullPropertyPointer(this.propertyNodePointer.getImmediateParentPointer());
            npp.setPropertyName(this.propertyNodePointer.getPropertyName());
            npp.setIndex(this.propertyNodePointer.getIndex());
            return npp.getValuePointer();
        }
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        return this.name == null ? this.setPositionAllProperties(position) : this.setPositionIndividualProperty(position);
    }

    private boolean setPositionIndividualProperty(int position) {
        int index;
        this.position = position;
        if (position < 1) {
            return false;
        }
        if (!this.targetReady) {
            this.prepareForIndividualProperty(this.name);
        }
        if (this.empty) {
            return false;
        }
        int length = this.getLength();
        if (!this.reverse) {
            index = position + this.startIndex;
            if (!this.includeStart) {
                ++index;
            }
            if (index > length) {
                return false;
            }
        } else {
            int end = this.startIndex;
            if (end == -1) {
                end = length - 1;
            }
            index = end - position + 2;
            if (!this.includeStart) {
                --index;
            }
            if (index < 1) {
                return false;
            }
        }
        this.propertyNodePointer.setIndex(index - 1);
        return true;
    }

    private boolean setPositionAllProperties(int position) {
        this.position = position;
        if (position < 1) {
            return false;
        }
        int count2 = this.propertyNodePointer.getPropertyCount();
        if (!this.reverse) {
            int index = 1;
            for (int i = this.startPropertyIndex; i < count2; ++i) {
                int offset;
                this.propertyNodePointer.setPropertyIndex(i);
                int length = this.getLength();
                if (i == this.startPropertyIndex) {
                    length -= this.startIndex;
                    if (!this.includeStart) {
                        --length;
                    }
                    offset = this.startIndex + position - index;
                    if (!this.includeStart) {
                        ++offset;
                    }
                } else {
                    offset = position - index;
                }
                if (index <= position && position < index + length) {
                    this.propertyNodePointer.setIndex(offset);
                    return true;
                }
                index += length;
            }
        } else {
            int index = 1;
            int start2 = this.startPropertyIndex;
            if (start2 == Integer.MIN_VALUE) {
                start2 = count2 - 1;
            }
            for (int i = start2; i >= 0; --i) {
                int offset;
                this.propertyNodePointer.setPropertyIndex(i);
                int length = this.getLength();
                if (i == this.startPropertyIndex) {
                    int end = this.startIndex;
                    if (end == -1) {
                        end = length - 1;
                    }
                    length = end + 1;
                    offset = end - position + 1;
                    if (!this.includeStart) {
                        --offset;
                        --length;
                    }
                } else {
                    offset = length - (position - index) - 1;
                }
                if (index <= position && position < index + length) {
                    this.propertyNodePointer.setIndex(offset);
                    return true;
                }
                index += length;
            }
        }
        return false;
    }

    protected void prepareForIndividualProperty(String name2) {
        this.targetReady = true;
        this.empty = true;
        String[] names2 = this.propertyNodePointer.getPropertyNames();
        if (!this.reverse) {
            if (this.startPropertyIndex == Integer.MIN_VALUE) {
                this.startPropertyIndex = 0;
            }
            if (this.startIndex == Integer.MIN_VALUE) {
                this.startIndex = 0;
            }
            for (int i = this.startPropertyIndex; i < names2.length; ++i) {
                if (!names2[i].equals(name2)) continue;
                this.propertyNodePointer.setPropertyIndex(i);
                if (i != this.startPropertyIndex) {
                    this.startIndex = 0;
                    this.includeStart = true;
                }
                this.empty = false;
                break;
            }
        } else {
            if (this.startPropertyIndex == Integer.MIN_VALUE) {
                this.startPropertyIndex = names2.length - 1;
            }
            if (this.startIndex == Integer.MIN_VALUE) {
                this.startIndex = -1;
            }
            for (int i = this.startPropertyIndex; i >= 0; --i) {
                if (!names2[i].equals(name2)) continue;
                this.propertyNodePointer.setPropertyIndex(i);
                if (i != this.startPropertyIndex) {
                    this.startIndex = -1;
                    this.includeStart = true;
                }
                this.empty = false;
                break;
            }
        }
    }

    private int getLength() {
        int length;
        try {
            length = this.propertyNodePointer.getLength();
        }
        catch (Throwable t) {
            length = 0;
        }
        return length;
    }
}

