/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.VariablePointer;

public class VariablePointerFactory
implements NodePointerFactory {
    public static final int VARIABLE_POINTER_FACTORY_ORDER = 890;

    public static VariableContextWrapper contextWrapper(JXPathContext context) {
        return new VariableContextWrapper(context);
    }

    public NodePointer createNodePointer(QName name2, Object object, Locale locale) {
        if (object instanceof VariableContextWrapper) {
            for (JXPathContext varCtx = ((VariableContextWrapper)object).getContext(); varCtx != null; varCtx = varCtx.getParentContext()) {
                Variables vars = varCtx.getVariables();
                if (!vars.isDeclaredVariable(name2.toString())) continue;
                return new VariablePointer(vars, name2);
            }
            return new VariablePointer(name2);
        }
        return null;
    }

    public NodePointer createNodePointer(NodePointer parent, QName name2, Object object) {
        return this.createNodePointer(name2, object, null);
    }

    public int getOrder() {
        return 890;
    }

    public static final class VariableContextWrapper {
        private final JXPathContext context;

        private VariableContextWrapper(JXPathContext context) {
            this.context = context;
        }

        public JXPathContext getContext() {
            return this.context;
        }
    }
}

