/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.util.ValueUtils;

public abstract class Expression {
    protected static final Double ZERO = new Double(0.0);
    protected static final Double ONE = new Double(1.0);
    protected static final Double NOT_A_NUMBER = new Double(Double.NaN);
    private boolean contextDependencyKnown = false;
    private boolean contextDependent;

    public synchronized boolean isContextDependent() {
        if (!this.contextDependencyKnown) {
            this.contextDependent = this.computeContextDependent();
            this.contextDependencyKnown = true;
        }
        return this.contextDependent;
    }

    public abstract boolean computeContextDependent();

    public abstract Object computeValue(EvalContext var1);

    public abstract Object compute(EvalContext var1);

    public Iterator iterate(EvalContext context) {
        Object result2 = this.compute(context);
        if (result2 instanceof EvalContext) {
            return new ValueIterator((EvalContext)result2);
        }
        if (result2 instanceof NodeSet) {
            return new ValueIterator(((NodeSet)result2).getPointers().iterator());
        }
        return ValueUtils.iterate(result2);
    }

    public Iterator iteratePointers(EvalContext context) {
        Object result2 = this.compute(context);
        if (result2 == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (result2 instanceof EvalContext) {
            return (EvalContext)result2;
        }
        if (result2 instanceof NodeSet) {
            return new PointerIterator(((NodeSet)result2).getPointers().iterator(), new QName(null, "value"), context.getRootContext().getCurrentNodePointer().getLocale());
        }
        return new PointerIterator(ValueUtils.iterate(result2), new QName(null, "value"), context.getRootContext().getCurrentNodePointer().getLocale());
    }

    public static class ValueIterator
    implements Iterator {
        private Iterator iterator;

        public ValueIterator(Iterator it) {
            this.iterator = it;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object o = this.iterator.next();
            return o instanceof Pointer ? ((Pointer)o).getValue() : o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PointerIterator
    implements Iterator {
        private Iterator iterator;
        private QName qname;
        private Locale locale;

        public PointerIterator(Iterator it, QName qname, Locale locale) {
            this.iterator = it;
            this.qname = qname;
            this.locale = locale;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object o = this.iterator.next();
            return o instanceof Pointer ? o : NodePointer.newNodePointer(this.qname, o, this.locale);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

