/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.InfoSetUtil;
import org.apache.commons.jxpath.ri.axes.InitialContext;
import org.apache.commons.jxpath.ri.axes.SelfContext;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.Expression;

public abstract class CoreOperationCompare
extends CoreOperation {
    private boolean invert;

    public CoreOperationCompare(Expression arg1, Expression arg2) {
        this(arg1, arg2, false);
    }

    protected CoreOperationCompare(Expression arg1, Expression arg2, boolean invert) {
        super(new Expression[]{arg1, arg2});
        this.invert = invert;
    }

    public Object computeValue(EvalContext context) {
        return this.equal(context, this.args[0], this.args[1]) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected int getPrecedence() {
        return 2;
    }

    protected boolean isSymmetric() {
        return true;
    }

    protected boolean equal(EvalContext context, Expression left, Expression right) {
        Iterator l = left.compute(context);
        Iterator r = right.compute(context);
        if (l instanceof InitialContext) {
            ((EvalContext)l).reset();
        }
        if (l instanceof SelfContext) {
            l = ((EvalContext)l).getSingleNodePointer();
        }
        if (r instanceof InitialContext) {
            ((EvalContext)r).reset();
        }
        if (r instanceof SelfContext) {
            r = ((EvalContext)r).getSingleNodePointer();
        }
        if (l instanceof Collection) {
            l = ((Collection)((Object)l)).iterator();
        }
        if (r instanceof Collection) {
            r = ((Collection)((Object)r)).iterator();
        }
        if (l instanceof Iterator && r instanceof Iterator) {
            return this.findMatch(l, r);
        }
        if (l instanceof Iterator) {
            return this.contains(l, r);
        }
        if (r instanceof Iterator) {
            return this.contains(r, l);
        }
        return this.equal(l, r);
    }

    protected boolean contains(Iterator it, Object value) {
        while (it.hasNext()) {
            Object element2 = it.next();
            if (!this.equal(element2, value)) continue;
            return true;
        }
        return false;
    }

    protected boolean findMatch(Iterator lit, Iterator rit) {
        HashSet left = new HashSet();
        while (lit.hasNext()) {
            left.add(lit.next());
        }
        while (rit.hasNext()) {
            if (!this.contains(left.iterator(), rit.next())) continue;
            return true;
        }
        return false;
    }

    protected boolean equal(Object l, Object r) {
        boolean result2;
        if (l instanceof Pointer) {
            l = ((Pointer)l).getValue();
        }
        if (r instanceof Pointer) {
            r = ((Pointer)r).getValue();
        }
        if (l instanceof Boolean || r instanceof Boolean) {
            result2 = l == r || InfoSetUtil.booleanValue(l) == InfoSetUtil.booleanValue(r);
        } else if (l instanceof Number || r instanceof Number) {
            double ld = InfoSetUtil.doubleValue(l);
            if (Double.isNaN(ld)) {
                return false;
            }
            double rd = InfoSetUtil.doubleValue(r);
            if (Double.isNaN(rd)) {
                return false;
            }
            result2 = ld == rd;
        } else {
            if (l instanceof String || r instanceof String) {
                l = InfoSetUtil.stringValue(l);
                r = InfoSetUtil.stringValue(r);
            }
            result2 = l == r || l != null && l.equals(r);
        }
        return result2 ^ this.invert;
    }
}

