/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.jxpath.Function;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.NodeSet;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.functions.ConstructorFunction;
import org.apache.commons.jxpath.functions.MethodFunction;
import org.apache.commons.jxpath.util.MethodLookupUtils;
import org.apache.commons.jxpath.util.TypeUtils;

public class PackageFunctions
implements Functions {
    private String classPrefix;
    private String namespace;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    static /* synthetic */ Class class$java$lang$Object;

    public PackageFunctions(String classPrefix, String namespace) {
        this.classPrefix = classPrefix;
        this.namespace = namespace;
    }

    public Set getUsedNamespaces() {
        return Collections.singleton(this.namespace);
    }

    public Function getFunction(String namespace, String name2, Object[] parameters) {
        Class<?> functionClass;
        String fullName;
        int inx;
        if (namespace == null && this.namespace != null || namespace != null && !namespace.equals(this.namespace)) {
            return null;
        }
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        if (parameters.length >= 1) {
            Method method;
            Object target = TypeUtils.convert(parameters[0], class$java$lang$Object == null ? (class$java$lang$Object = PackageFunctions.class$("java.lang.Object")) : class$java$lang$Object);
            if (target != null) {
                method = MethodLookupUtils.lookupMethod(target.getClass(), name2, parameters);
                if (method != null) {
                    return new MethodFunction(method);
                }
                if (target instanceof NodeSet) {
                    target = ((NodeSet)target).getPointers();
                }
                if ((method = MethodLookupUtils.lookupMethod(target.getClass(), name2, parameters)) != null) {
                    return new MethodFunction(method);
                }
                if (target instanceof Collection) {
                    Iterator iter2 = ((Collection)target).iterator();
                    if (iter2.hasNext()) {
                        target = iter2.next();
                        if (target instanceof Pointer) {
                            target = ((Pointer)target).getValue();
                        }
                    } else {
                        target = null;
                    }
                }
            }
            if (target != null && (method = MethodLookupUtils.lookupMethod(target.getClass(), name2, parameters)) != null) {
                return new MethodFunction(method);
            }
        }
        if ((inx = (fullName = this.classPrefix + name2).lastIndexOf(46)) == -1) {
            return null;
        }
        String className = fullName.substring(0, inx);
        String methodName = fullName.substring(inx + 1);
        try {
            functionClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new JXPathException("Cannot invoke extension function " + (namespace != null ? namespace + ":" + name2 : name2), ex);
        }
        if (methodName.equals("new")) {
            Constructor constructor = MethodLookupUtils.lookupConstructor(functionClass, parameters);
            if (constructor != null) {
                return new ConstructorFunction(constructor);
            }
        } else {
            Method method = MethodLookupUtils.lookupStaticMethod(functionClass, methodName, parameters);
            if (method != null) {
                return new MethodFunction(method);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

