/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils.getopt;

import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import de.fau.cs.osr.utils.getopt.IllegalOptionException;
import de.fau.cs.osr.utils.getopt.OptionState;
import de.fau.cs.osr.utils.getopt.UnrecognizedPropertyException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import joptsimple.OptionSet;
import joptsimple.internal.ColumnarData;

public class Configuration {
    private final Map<String, OptionState> options = new HashMap<String, OptionState>();
    private final Map<String, OptionState> properties = new HashMap<String, OptionState>();
    private final Properties propSet = new Properties();
    private OptionSet optSet;

    protected void add(OptionState optionState) {
        for (String name2 : optionState.getNames()) {
            this.options.put(name2, optionState);
        }
        this.properties.put(optionState.getPropertyKey(), optionState);
    }

    public void setOptionSet(OptionSet optSet) {
        this.optSet = optSet;
    }

    public void loadProperties(Properties p) {
        for (Object key : p.keySet()) {
            OptionState option = this.properties.get(key);
            if (option != null && !option.isFixed()) continue;
            throw new UnrecognizedPropertyException((String)key);
        }
        this.propSet.putAll((Map<?, ?>)p);
    }

    protected OptionState updateState(char shortOpt) {
        OptionState state = this.getOptByShort(shortOpt);
        state.setValid(true);
        return state;
    }

    protected OptionState updateState(String longOpt) {
        OptionState state = this.getOptByName(longOpt);
        state.setValid(true);
        return state;
    }

    protected void checkForInvalidOptions() throws IllegalOptionException {
        if (this.optSet == null) {
            return;
        }
        for (OptionState state : this.options.values()) {
            if (!this.optSet.has(state.getSpec()) || state.isValid()) continue;
            throw new IllegalOptionException(state.formatNames());
        }
    }

    private OptionState getOptByShort(char shortOpt) {
        OptionState state = this.options.get(String.valueOf(shortOpt));
        if (state == null) {
            throw new FmtIllegalArgumentException("Short option `%s' was not specified.", String.valueOf(shortOpt));
        }
        return state;
    }

    private OptionState getOptByName(String name2) {
        OptionState state = this.get(name2);
        if (state == null) {
            throw new FmtIllegalArgumentException("Option or property key `%s' was not specified.", name2);
        }
        return state;
    }

    private OptionState get(String option) {
        OptionState o = this.options.get(option);
        if (o != null) {
            return o;
        }
        return this.properties.get(option);
    }

    public boolean has(String option) {
        OptionState o = this.getOptByName(option);
        if (this.optSet != null && this.optSet.has(o.getSpec())) {
            return true;
        }
        return o.getPropertyKey() != null && this.propSet.containsKey(o.getPropertyKey());
    }

    public String valueOf(String option) {
        OptionState o = this.getOptByName(option);
        String value = this.valueOfNoDefault(o);
        if (value != null) {
            return value;
        }
        return o.getSafeDefaultValue();
    }

    public String valueOf(String option, String default_) {
        String value = this.valueOfNoDefault(option);
        if (value != null) {
            return value;
        }
        return default_;
    }

    public String valueOfNoDefault(String option) {
        return this.valueOfNoDefault(this.getOptByName(option));
    }

    private String valueOfNoDefault(OptionState o) {
        String value = null;
        if (this.optSet != null && o.getSpec() != null && (value = (String)this.optSet.valueOf(o.getSpec())) != null) {
            return value;
        }
        if (o.getPropertyKey() != null && (value = this.propSet.getProperty(o.getPropertyKey())) != null) {
            return value;
        }
        return null;
    }

    public List<String> valuesOf(String option) {
        OptionState o = this.getOptByName(option);
        List<String> values = this.valuesOfNoDefault(o);
        if (values != null) {
            return values;
        }
        return o.getSafeDefaultValues();
    }

    private List<String> valuesOfNoDefault(OptionState o) {
        List<String> values = null;
        if (this.optSet != null && (values = this.optSet.valuesOf(o.getSpec())) != null) {
            return values;
        }
        if (o.getPropertyKey() != null && (values = this.propToList(o)) != null) {
            return values;
        }
        return null;
    }

    private List<String> propToList(OptionState o) {
        String value = this.propSet.getProperty(o.getPropertyKey());
        StringTokenizer lexer = new StringTokenizer(value, o.getSafeDelim());
        ArrayList<String> values = new ArrayList<String>();
        while (lexer.hasMoreTokens()) {
            values.add(lexer.nextToken());
        }
        return values;
    }

    public List<String> nonOptionArguments() {
        if (this.optSet != null) {
            return this.optSet.nonOptionArguments();
        }
        return Collections.emptyList();
    }

    public Properties propertySubset(String prefix) {
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        int beginIndex = prefix.length();
        Properties subset = new Properties();
        for (OptionState o : this.properties.values()) {
            String key = o.getPropertyKey();
            if (key == null || !key.startsWith(prefix)) continue;
            String value = this.valueOfNoDefault(o);
            if (value == null) {
                value = o.getSafeDefaultValue();
            }
            if (value == null) continue;
            String newKey = key.substring(beginIndex);
            subset.setProperty(newKey, value);
        }
        return subset;
    }

    public void propertiesHelp(PrintStream out) {
        ColumnarData grid = new ColumnarData("Property key", "Description");
        ArrayList<OptionState> list = new ArrayList<OptionState>();
        for (OptionState s2 : this.properties.values()) {
            if (s2.getPropertyKey() == null) continue;
            list.add(s2);
        }
        Collections.sort(list, new Comparator<OptionState>(){

            @Override
            public int compare(OptionState o1, OptionState o2) {
                return o1.getPropertyKey().compareTo(o2.getPropertyKey());
            }
        });
        for (OptionState o : list) {
            List<String> defaults;
            if (o.isFixed()) continue;
            StringBuilder name2 = new StringBuilder();
            name2.append(o.getPropertyKey());
            if (o.getArgName() != null && !o.getArgName().isEmpty()) {
                name2.append("=<");
                name2.append(o.getArgName());
                name2.append('>');
            }
            StringBuilder desc = new StringBuilder();
            desc.append(o.getDescription());
            boolean sa = false;
            if (o.getNames() != null && !o.getNames().isEmpty()) {
                desc.append(" (see also: ");
                boolean first = true;
                for (String n : o.getNames()) {
                    if (!first) {
                        desc.append(", ");
                    }
                    desc.append(n.length() == 1 ? "-" : "--");
                    desc.append(n);
                    first = false;
                }
                sa = true;
            }
            if ((defaults = o.getSafeDefaultValues()) != null && !defaults.isEmpty()) {
                desc.append(sa ? "; " : " (");
                desc.append("default: ");
                boolean first = true;
                boolean hasDelim = !o.getSafeDelim().equals("\u0000");
                for (String d : defaults) {
                    if (!first && hasDelim) {
                        desc.append(o.getSafeDelim());
                    }
                    desc.append(d);
                    first = false;
                }
                desc.append(")");
            } else if (sa) {
                desc.append(")");
            }
            grid.addRow(name2.toString(), desc.toString());
        }
        out.print(grid.format());
    }

    public void fixedOptionsHelp(PrintStream out) {
        ColumnarData grid = new ColumnarData("Name", "Description");
        ArrayList<OptionState> list = new ArrayList<OptionState>();
        for (OptionState s2 : this.properties.values()) {
            if (!s2.isFixed()) continue;
            list.add(s2);
        }
        Collections.sort(list, new Comparator<OptionState>(){

            @Override
            public int compare(OptionState o1, OptionState o2) {
                return o1.getPropertyKey().compareTo(o2.getPropertyKey());
            }
        });
        for (OptionState o : list) {
            if (!o.isFixed()) continue;
            StringBuilder name2 = new StringBuilder();
            name2.append(o.getPropertyKey());
            List<String> defaults = o.getSafeDefaultValues();
            if (defaults != null && !defaults.isEmpty()) {
                name2.append("=");
                boolean first = true;
                boolean hasDelim = !o.getSafeDelim().equals("\u0000");
                for (String d : defaults) {
                    if (!first && hasDelim) {
                        name2.append(o.getSafeDelim());
                    }
                    name2.append(d);
                    first = false;
                }
            }
            String desc = o.getDescription() != null ? o.getDescription() : "-";
            grid.addRow(name2.toString(), desc);
        }
        out.print(grid.format());
    }
}

