/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.util.Collection;
import org.apache.commons.lang.StringEscapeUtils;

public final class StringUtils {
    public static String escHtml(String text2) {
        if (text2 == null) {
            return "";
        }
        int n = text2.length();
        StringBuffer sb = new StringBuffer(n * 4 / 3);
        block7: for (int i = 0; i < n; ++i) {
            char c = text2.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escJava(String text2) {
        return StringEscapeUtils.escapeJava(text2);
    }

    public static String join(Collection<?> c) {
        StringBuilder b = new StringBuilder();
        for (Object o : c) {
            b.append(o.toString());
        }
        return b.toString();
    }

    public static String strrep(char c, int times) {
        return org.apache.commons.lang.StringUtils.repeat(Character.toString(c), times);
    }

    public static String strrep(String str, int times) {
        return org.apache.commons.lang.StringUtils.repeat(str, times);
    }

    public static String crop(String str, int length) {
        return org.apache.commons.lang.StringUtils.abbreviate(str, length);
    }

    public static String indent(String text2, String indent) {
        if (text2 == null) {
            return "";
        }
        int n = text2.length();
        StringBuilder result2 = new StringBuilder(n * 2);
        result2.append(indent);
        block4: for (int i = 0; i < n; ++i) {
            char ch = text2.charAt(i);
            result2.append(ch);
            switch (ch) {
                case '\n': {
                    result2.append(indent);
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < n && text2.charAt(i + 1) == '\n') {
                        result2.append('\n');
                        ++i;
                    }
                    result2.append(indent);
                }
            }
        }
        return result2.toString();
    }

    public static String indent2(String text2, String indent) {
        if (text2 == null) {
            return "";
        }
        int n = text2.length();
        StringBuilder result2 = new StringBuilder(n * 2);
        block4: for (int i = 0; i < n; ++i) {
            char ch = text2.charAt(i);
            result2.append(ch);
            switch (ch) {
                case '\n': {
                    result2.append(indent);
                    continue block4;
                }
                case '\r': {
                    if (i + 1 < n && text2.charAt(i + 1) == '\n') {
                        result2.append('\n');
                        ++i;
                    }
                    result2.append(indent);
                }
            }
        }
        return result2.toString();
    }

    public static String camelcaseToUppercase(String camelCase) {
        int n = camelCase.length();
        StringBuilder upperCase = new StringBuilder(n * 4 / 3);
        for (int i = 0; i < n; ++i) {
            char ch = camelCase.charAt(i);
            if (Character.isUpperCase(ch)) {
                upperCase.append('_');
                upperCase.append(ch);
                continue;
            }
            upperCase.append(Character.toUpperCase(ch));
        }
        return upperCase.toString();
    }

    public static String startWithUppercase(String name2) {
        return name2.substring(0, 1).toUpperCase() + name2.substring(1);
    }
}

