/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RingBuffer<T>
implements Iterable<T> {
    private final Object[] buffer;
    private int fill = 0;
    private int start = 0;

    public RingBuffer(int capacity) {
        this.buffer = new Object[capacity];
    }

    public void add(T x) {
        if (this.fill == this.buffer.length) {
            this.start = (this.start + 1) % this.buffer.length;
            this.buffer[(this.start + this.fill) % this.buffer.length] = x;
        } else {
            this.buffer[(this.start + this.fill) % this.buffer.length] = x;
            ++this.fill;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < RingBuffer.this.fill;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RingBuffer.this.buffer[(RingBuffer.this.start + this.i++) % RingBuffer.this.buffer.length];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.fill;
    }
}

