/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.lang.reflect.Array;

public class ReflectionUtils {
    public static Class<?> classForName(String className) throws ClassNotFoundException {
        if (className == "byte") {
            return Byte.TYPE;
        }
        if (className == "short") {
            return Short.TYPE;
        }
        if (className == "int") {
            return Integer.TYPE;
        }
        if (className == "long") {
            return Long.TYPE;
        }
        if (className == "float") {
            return Float.TYPE;
        }
        if (className == "double") {
            return Double.TYPE;
        }
        if (className == "boolean") {
            return Boolean.TYPE;
        }
        if (className == "char") {
            return Character.TYPE;
        }
        if (className == "void") {
            return Void.TYPE;
        }
        return Class.forName(className);
    }

    public static boolean isExtPrimitive(Class<?> clazz) {
        return clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Boolean.class || clazz == Character.class || clazz == Void.class;
    }

    public static Class<?> arrayClassFor(Class<?> clazz, int dim) {
        if (dim <= 0) {
            throw new IllegalArgumentException("Invalid dimension");
        }
        Class<?> arrayClass = clazz;
        for (int i = 1; i <= dim; ++i) {
            arrayClass = Array.newInstance(arrayClass, 0).getClass();
        }
        return arrayClass;
    }

    public static ArrayInfo arrayDimension(Class<?> clazz) {
        int dim = 0;
        Class<?> cClass = clazz;
        while (cClass.isArray()) {
            cClass = cClass.getComponentType();
            ++dim;
        }
        return new ArrayInfo(cClass, dim);
    }

    public static final class ArrayInfo {
        public final Class<?> elementClass;
        public final int dim;

        public ArrayInfo(Class<?> elementClass, int dim) {
            this.elementClass = elementClass;
            this.dim = dim;
        }
    }
}

