/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class BuildInfo {
    private String groupId;
    private String artifaceId;
    private String projectName;
    private String projectVersion;
    private String vendor;
    private String gitBranch;
    private String gitBuildUserName;
    private String gitBuildUserEmail;
    private String gitBuildTime;
    private String gitCommitId;
    private String gitCommitIdAbbrev;
    private String gitCommitUserName;
    private String gitCommitUserEmail;
    private String gitCommitMessageFull;
    private String gitCommitMessageShort;
    private String gitCommitTime;

    public static BuildInfo build(String groupId, String artifactId, ClassLoader cl) {
        String aid;
        if (groupId == null || artifactId == null || cl == null) {
            throw new NullPointerException();
        }
        BuildInfo info = new BuildInfo();
        info.groupId = groupId;
        info.artifaceId = artifactId;
        String path = String.format("%s/%s.buildinfo.properties", groupId.replace('.', '/'), artifactId);
        InputStream is = cl.getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            InputStreamReader r = new InputStreamReader(is, "UTF-8");
            properties.load(r);
            is.close();
        }
        catch (IOException e) {
            return null;
        }
        String gid = properties.getProperty("project.groupId");
        if (gid != null) {
            info.groupId = gid;
        }
        if ((aid = properties.getProperty("project.artifactId")) != null) {
            info.artifaceId = aid;
        }
        info.projectName = properties.getProperty("project.name");
        info.projectVersion = properties.getProperty("project.version");
        info.vendor = properties.getProperty("organization.name");
        info.gitBranch = properties.getProperty("git.branch");
        info.gitBuildUserName = properties.getProperty("git.build.user.name");
        info.gitBuildUserEmail = properties.getProperty("git.build.user.email");
        info.gitBuildTime = properties.getProperty("git.build.time");
        info.gitCommitId = properties.getProperty("git.commit.id");
        info.gitCommitIdAbbrev = properties.getProperty("git.commit.id.abbrev");
        info.gitCommitUserName = properties.getProperty("git.commit.user.name");
        info.gitCommitUserEmail = properties.getProperty("git.commit.user.email");
        info.gitCommitMessageFull = properties.getProperty("git.commit.message.full");
        info.gitCommitMessageShort = properties.getProperty("git.commit.message.short");
        info.gitCommitTime = properties.getProperty("git.commit.time");
        return info;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifaceId() {
        return this.artifaceId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public String getGitBuildUserName() {
        return this.gitBuildUserName;
    }

    public String getGitBuildUserEmail() {
        return this.gitBuildUserEmail;
    }

    public String getGitBuildTime() {
        return this.gitBuildTime;
    }

    public String getGitCommitId() {
        return this.gitCommitId;
    }

    public String getGitCommitIdAbbrev() {
        return this.gitCommitIdAbbrev;
    }

    public String getGitCommitUserName() {
        return this.gitCommitUserName;
    }

    public String getGitCommitUserEmail() {
        return this.gitCommitUserEmail;
    }

    public String getGitCommitMessageFull() {
        return this.gitCommitMessageFull;
    }

    public String getGitCommitMessageShort() {
        return this.gitCommitMessageShort;
    }

    public String getGitCommitTime() {
        return this.gitCommitTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.groupId != null) {
            sb.append("groupId               : " + this.groupId + "\n");
        }
        if (this.artifaceId != null) {
            sb.append("artifaceId            : " + this.artifaceId + "\n");
        }
        if (this.projectName != null) {
            sb.append("projectName           : " + this.projectName + "\n");
        }
        if (this.projectVersion != null) {
            sb.append("projectVersion        : " + this.projectVersion + "\n");
        }
        if (this.vendor != null) {
            sb.append("vendor                : " + this.vendor + "\n");
        }
        if (this.gitBranch != null) {
            sb.append("gitBranch             : " + this.gitBranch + "\n");
        }
        if (this.gitBuildUserName != null) {
            sb.append("gitBuildUserName      : " + this.gitBuildUserName + "\n");
        }
        if (this.gitBuildUserEmail != null) {
            sb.append("gitBuildUserEmail     : " + this.gitBuildUserEmail + "\n");
        }
        if (this.gitBuildTime != null) {
            sb.append("gitBuildTime          : " + this.gitBuildTime + "\n");
        }
        if (this.gitCommitId != null) {
            sb.append("gitCommitId           : " + this.gitCommitId + "\n");
        }
        if (this.gitCommitIdAbbrev != null) {
            sb.append("gitCommitIdAbbrev     : " + this.gitCommitIdAbbrev + "\n");
        }
        if (this.gitCommitUserName != null) {
            sb.append("gitCommitUserName     : " + this.gitCommitUserName + "\n");
        }
        if (this.gitCommitUserEmail != null) {
            sb.append("gitCommitUserEmail    : " + this.gitCommitUserEmail + "\n");
        }
        if (this.gitCommitMessageFull != null) {
            sb.append("gitCommitMessageFull  : " + this.gitCommitMessageFull + "\n");
        }
        if (this.gitCommitMessageShort != null) {
            sb.append("gitCommitMessageShort : " + this.gitCommitMessageShort + "\n");
        }
        if (this.gitCommitTime != null) {
            sb.append("gitCommitTime         : " + this.gitCommitTime + "\n");
        }
        return sb.toString();
    }
}

