/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.test;

import de.fau.cs.osr.utils.FmtIllegalArgumentException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public class ParserTestResources {
    File baseDirectory;

    public ParserTestResources(File baseDirectory) {
        if (!baseDirectory.exists()) {
            throw new FmtIllegalArgumentException("Given base directory `%s' does not exist", baseDirectory);
        }
        if (!baseDirectory.isDirectory()) {
            throw new FmtIllegalArgumentException("Given base directory `%s' is not a directory", baseDirectory);
        }
        this.baseDirectory = baseDirectory;
    }

    public List<File> gather(String directory, String glob, final boolean recursive) {
        LinkedList<File> files2 = new LinkedList<File>();
        final Pattern p = Pattern.compile(glob);
        FilenameFilter filter2 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name2) {
                Matcher matcher = p.matcher(name2);
                if (matcher.matches()) {
                    return true;
                }
                if (recursive) {
                    return new File(dir, name2).isDirectory();
                }
                return false;
            }
        };
        File dir = new File(this.baseDirectory, directory);
        if (!dir.exists()) {
            throw new FmtIllegalArgumentException("Given directory `%s' does not exist", dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new FmtIllegalArgumentException("Given directory `%s' is not a directory", dir.getAbsolutePath());
        }
        ParserTestResources.gatherRecursive(dir, filter2, files2);
        Collections.sort(files2);
        return files2;
    }

    private static void gatherRecursive(File directory, FilenameFilter filter2, List<File> gathered) {
        String[] files2 = directory.list(filter2);
        if (files2 != null) {
            for (String fileName : files2) {
                File file = new File(directory, fileName);
                if (file.isDirectory()) {
                    ParserTestResources.gatherRecursive(file, filter2, gathered);
                    continue;
                }
                gathered.add(file);
            }
        }
    }

    public String stripBaseDirectoryAndFixPath(String text2) {
        String p = Pattern.quote(this.baseDirectory.getAbsolutePath());
        Pattern rx = Pattern.compile(p + "(.*?:)");
        StringBuilder b = new StringBuilder();
        Matcher m = rx.matcher(text2);
        int begin = 0;
        while (m.find(begin)) {
            b.append(text2.substring(begin, m.start()));
            b.append(m.group(1).replace(File.separatorChar, '/'));
            begin = m.end();
        }
        if (begin < text2.length()) {
            b.append(text2.substring(begin, text2.length()));
        }
        return b.toString();
    }

    public static File rebase(File file, String base, String rebase) {
        String unixPath = ParserTestResources.fileSeparatorToUnix(file.getAbsolutePath());
        File rebasedFile = new File(unixPath.replace(base, rebase));
        if (!rebasedFile.exists()) {
            throw new FmtIllegalArgumentException("Rebased file `%s' does not exist", rebasedFile.getAbsolutePath());
        }
        return rebasedFile;
    }

    public static File rebase(File file, String base, String rebase, String ext) {
        return ParserTestResources.rebase(file, base, rebase, ext, false);
    }

    public static File rebase(File file, String base, String rebase, String ext, boolean noThrow) {
        String unixPath = ParserTestResources.fileSeparatorToUnix(file.getAbsolutePath());
        String rebased = unixPath.replace(base, rebase);
        int i = rebased.lastIndexOf(46);
        rebased = i < 0 ? rebased + "." + ext : rebased.substring(0, i + 1) + ext;
        File rebasedFile = new File(rebased);
        if (!rebasedFile.exists() && !noThrow) {
            throw new FmtIllegalArgumentException("Rebased file `%s' does not exist", rebasedFile.getAbsolutePath());
        }
        return rebasedFile;
    }

    public static String fileSeparatorToUnix(String path) {
        if (File.separatorChar != '/') {
            Assert.assertTrue("Test code doesn't work properly if path conatins a '/'.", path.indexOf(47) == -1);
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public static String lineEndToUnix(String result2) {
        result2 = result2.replace("\r\n", "\n");
        result2 = result2.replace("\r", "\n");
        return result2;
    }
}

