/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.test;

import de.fau.cs.osr.ptk.common.AstPrinterInterface;
import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ParserInterface;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.test.FileContent;
import de.fau.cs.osr.ptk.common.test.ParserTestResources;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import xtc.parser.ParseException;

public abstract class IntegrationTestBase {
    private static ParserTestResources resources;
    private static Pattern inputPathToRefPathSearch;
    private static String inputPathToRefPathReplaceWith;
    private final boolean randomRefName;
    private final boolean putInitialRefFilesIntoRefFileDir;

    public static void setResources(ParserTestResources resources) {
        IntegrationTestBase.resources = resources;
    }

    protected static ParserTestResources getResources() {
        return resources;
    }

    protected static List<Object[]> gather(String inputSubDir, String filterRx, boolean recursive) {
        LinkedList<Object[]> inputs = new LinkedList<Object[]>();
        for (File file : IntegrationTestBase.getResources().gather(inputSubDir, filterRx, recursive)) {
            inputs.add(new Object[]{file.getName(), file});
        }
        return inputs;
    }

    public IntegrationTestBase() {
        this.randomRefName = false;
        this.putInitialRefFilesIntoRefFileDir = false;
    }

    public IntegrationTestBase(boolean randomRefName, boolean putInitialRefFilesIntoRefFileDir) {
        this.randomRefName = randomRefName;
        this.putInitialRefFilesIntoRefFileDir = putInitialRefFilesIntoRefFileDir;
    }

    protected void parsePrintAndCompare(File inputFile, AstVisitor[] visitors, String inputSubDir, String expectedSubDir, AstPrinterInterface printer) throws IOException, ParseException {
        AstNode ast = this.parse(inputFile, visitors);
        String actual = this.printToString(ast, printer);
        File expectedFile = ParserTestResources.rebase(inputFile, inputSubDir, expectedSubDir, printer.getPrintoutType(), true);
        this.compareWithExpectedOrGenerateExpectedFromActual(expectedFile, actual);
    }

    protected abstract ParserInterface instantiateParser();

    private AstNode parse(File inputFile, AstVisitor[] visitors) throws IOException, ParseException {
        ParserInterface parser = this.instantiateParser();
        if (visitors != null) {
            parser.addVisitors(Arrays.asList(visitors));
        }
        FileContent inputFileContent = new FileContent(inputFile);
        return parser.parseArticle(inputFileContent.getContent(), inputFile.getAbsolutePath());
    }

    public String printToString(AstNode ast, AstPrinterInterface printer) throws IOException {
        StringWriter writer2 = new StringWriter();
        printer.print(ast, writer2);
        String result2 = writer2.toString();
        result2 = ParserTestResources.lineEndToUnix(result2);
        return resources.stripBaseDirectoryAndFixPath(result2);
    }

    private void compareWithExpectedOrGenerateExpectedFromActual(File expectedFile, String actual) throws IOException {
        if (!expectedFile.exists()) {
            File create2;
            if (this.putInitialRefFilesIntoRefFileDir) {
                String dir = expectedFile.getParentFile().getAbsolutePath();
                ParserTestResources.fileSeparatorToUnix(dir);
                if (inputPathToRefPathSearch == null) {
                    inputPathToRefPathSearch = Pattern.compile("(.*?)" + Pattern.quote("/target/test-classes/"));
                }
                if (!inputPathToRefPathSearch.matcher(dir).find()) {
                    Assert.fail("Reference file did not exist! FAILED TO WRITE REFERENCE FILE!");
                }
                if (inputPathToRefPathReplaceWith == null) {
                    inputPathToRefPathReplaceWith = "$1" + Pattern.quote("/src/test/resources/");
                }
                dir = inputPathToRefPathSearch.matcher(dir).replaceAll(inputPathToRefPathReplaceWith);
                create2 = new File(dir);
            } else {
                create2 = new File("").getAbsoluteFile();
            }
            create2 = this.randomRefName ? File.createTempFile(expectedFile.getName() + "-", "", create2) : new File(create2, expectedFile.getName());
            FileUtils.writeStringToFile(create2, actual);
            Assert.fail("Reference file did not exist! Wrote initial reference file to: " + create2.getAbsolutePath());
        } else {
            FileContent reftext = new FileContent(expectedFile);
            String reference = ParserTestResources.lineEndToUnix(reftext.getContent());
            Assert.assertEquals(reference, actual);
        }
    }

    static {
        URL url = IntegrationTestBase.class.getResource("/");
        resources = new ParserTestResources(new File(url.getFile()));
    }
}

