/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common.ast;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.Location;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AstNodeOutputStream
extends DataOutputStream {
    public static final int NULL_ID = 0;
    public static final int OBJECT_ID = 1;
    public static final int STRING_ID = 16;
    public static final int BYTE_ID = 32;
    public static final int SHORT_ID = 33;
    public static final int INTEGER_ID = 34;
    public static final int LONG_ID = 35;
    public static final int FLOAT_ID = 36;
    public static final int DOUBLE_ID = 37;
    public static final int ASTNODE_ID = 256;
    public static final int LOCATION_ID = 257;
    public static final int SWITCH_MASK = -65536;
    public static final int SWITCH_SHIFT = 16;
    public static final int CACHED_BIT = 65536;
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    private final Map<String, Integer> cache = new HashMap<String, Integer>(4096);
    private final ObjectOutputStream objectOutputStream;

    public AstNodeOutputStream(OutputStream os) throws IOException {
        super(os);
        this.objectOutputStream = new ObjectOutputStream(os);
    }

    public void writeByte(Byte o) throws IOException {
        this.writeInt(32);
        this.writeByte((int)o.byteValue());
    }

    public void writeShort(Short o) throws IOException {
        this.writeInt(33);
        this.writeShort((int)o.shortValue());
    }

    public void writeInt(Integer o) throws IOException {
        this.writeInt(34);
        this.writeInt((int)o);
    }

    public void writeLong(Long o) throws IOException {
        this.writeInt(35);
        this.writeLong((long)o);
    }

    public void writeFloat(Float o) throws IOException {
        this.writeInt(36);
        this.writeFloat(o.floatValue());
    }

    public void writeDouble(Double o) throws IOException {
        this.writeInt(37);
        this.writeDouble((double)o);
    }

    public void writeString(String o) throws IOException {
        this.writeCached(o);
    }

    public void writeNode(AstNode n) throws IOException {
        if (n == null) {
            this.writeNullObj();
        } else {
            this.writeInt(256);
            this.writeClassName(n);
            n.serializeTo(this);
        }
    }

    private void writeLocation(Location o) throws IOException {
        if (o == null) {
            this.writeNullObj();
        } else {
            this.writeInt(257);
            this.writeString(o.getFile());
            this.writeInt(o.getLine());
            this.writeInt(o.getColumn());
        }
    }

    public void writeObject(Object o) throws IOException {
        if (o == null) {
            this.writeNullObj();
        } else if (o instanceof String) {
            this.writeString((String)o);
        } else if (o instanceof Number) {
            if (o instanceof Integer) {
                this.writeInt((Integer)o);
            } else if (o instanceof Float) {
                this.writeFloat((Float)o);
            } else if (o instanceof Long) {
                this.writeLong((Long)o);
            } else if (o instanceof Byte) {
                this.writeByte((Byte)o);
            } else if (o instanceof Short) {
                this.writeShort((Short)o);
            } else if (o instanceof Double) {
                this.writeDouble((Double)o);
            } else {
                this.writeObj(o);
            }
        } else if (o instanceof AstNode) {
            this.writeNode((AstNode)o);
        } else if (o instanceof Location) {
            this.writeLocation((Location)o);
        } else {
            this.writeObj(o);
        }
    }

    private void writeNullObj() throws IOException {
        this.writeInt(0);
    }

    private void writeCached(String str) throws IOException {
        if (str == null) {
            this.writeNullObj();
        } else {
            Integer id = this.cache.get(str);
            if (id != null) {
                this.writeInt(65552);
                this.writeInt((int)id);
            } else {
                this.writeInt(16);
                this.cache.put(str, this.cache.size());
                this.writeUTF(str);
            }
        }
    }

    private void writeClassName(AstNode n) throws IOException {
        this.writeCached(n.getClass().getName());
    }

    private void writeObj(Object o) throws IOException {
        this.writeInt(1);
        this.objectOutputStream.writeObject(o);
    }

    public Set<String> getCachedString() {
        return this.cache.keySet();
    }
}

