/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.ast.Span;
import java.io.Serializable;

public abstract class Warning
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Span span;
    private final String origin;
    private final String message;

    public Warning() {
        this(new Span(), "Unknown origin", "Unknown warning.");
    }

    public Warning(Span span2, String origin, String message) {
        this.span = span2;
        this.origin = origin;
        this.message = message;
    }

    public Warning(Span span2, Class<?> origin, String message) {
        this(span2, origin.getSimpleName(), message);
    }

    public Span getSpan() {
        return this.span;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String span2 = this.spanToString();
        String message = this.messageToString();
        return "Warning: " + span2 + " : " + message;
    }

    protected String spanToString() {
        String span2 = "<no location>";
        if (this.span != null) {
            span2 = this.span.toString();
        }
        return span2;
    }

    protected String messageToString() {
        String message = this.message;
        if (message == null || message.isEmpty()) {
            message = "<no message>";
        }
        switch (message.charAt(message.length() - 1)) {
            case '!': 
            case '.': 
            case '?': {
                break;
            }
            default: {
                message = message + ".";
            }
        }
        return message;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.message == null ? 0 : this.message.hashCode());
        result2 = 31 * result2 + (this.origin == null ? 0 : this.origin.hashCode());
        result2 = 31 * result2 + (this.span == null ? 0 : this.span.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Warning other = (Warning)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        return !(this.span == null ? other.span != null : !this.span.equals(other.span));
    }
}

