/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PrinterBase
extends AstVisitor {
    private PrintWriter out;
    private Stack<String> indent = new Stack();
    private boolean needIndent = true;

    protected PrinterBase(Writer writer2) {
        this.out = new PrintWriter(writer2);
        this.indent.push("");
    }

    @Override
    protected Object after(AstNode node, Object result2) {
        this.out.close();
        return super.after(node, result2);
    }

    protected void incIndent(String inc) {
        this.indent.push(this.indent.peek() + inc);
    }

    protected void decIndent() {
        this.indent.pop();
    }

    protected void print(String text2) {
        if (text2 == null) {
            return;
        }
        if (this.needIndent) {
            this.out.append(this.indent.peek());
            this.needIndent = false;
        }
        this.out.append(text2);
    }

    protected void print(int number) {
        this.print(String.valueOf(number));
    }

    protected void printNewline(boolean force) {
        if (!this.needIndent || force) {
            this.out.append("\n");
            this.needIndent = true;
        }
    }

    protected String indentText(String text2) {
        return StringUtils.indent2(text2, this.indent.peek());
    }

    protected static String load(File file) throws IOException {
        return FileUtils.readFileToString(file);
    }

    protected String loadFromResource(String resourceName) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(resourceName);
        if (in == null) {
            throw new FileNotFoundException("Resource not found: `" + resourceName + "'.");
        }
        return IOUtils.toString(in);
    }

    protected static String camelCaseToUppercase(String name2) {
        return StringUtils.camelcaseToUppercase(name2);
    }

    protected static String startWithUppercase(String name2) {
        return StringUtils.startWithUppercase(name2);
    }

    protected static String escHtml(String text2) {
        return StringUtils.escHtml(text2);
    }

    protected static String escJavaHtml(String text2) {
        return StringUtils.escHtml(StringUtils.escJava(text2));
    }

    protected static String strrep(char ch, int rep) {
        return StringUtils.strrep(ch, rep);
    }

    protected static String strrep(String str, int rep) {
        return StringUtils.strrep(str, rep);
    }
}

