/*
 * Decompiled with CFR 0.152.
 */
package de.fau.cs.osr.ptk.common;

import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;

public class AstComparer {
    private final boolean compareAttributes;
    private final boolean compareLocation;

    protected AstComparer(boolean compareAttributes, boolean compareLocation) {
        this.compareAttributes = compareAttributes;
        this.compareLocation = compareLocation;
    }

    public static boolean compare(AstNode rootA, AstNode rootB, boolean compareAttributes, boolean compareLocation) {
        return new AstComparer(compareAttributes, compareLocation).compareIntern(rootA, rootB);
    }

    private boolean compareIntern(AstNode a, AstNode b) {
        String[] bcn;
        if (a == b) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        if (a == null) {
            return true;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (this.compareLocation && (a.getNativeLocation() == null ? b.getNativeLocation() != null : !a.getNativeLocation().equals(b.getNativeLocation()))) {
            return false;
        }
        if (this.compareAttributes && !a.getAttributes().equals(b.getAttributes())) {
            return false;
        }
        AstNodePropertyIterator i = a.propertyIterator();
        AstNodePropertyIterator j = b.propertyIterator();
        while (i.next()) {
            if (!j.next()) {
                return false;
            }
            if (!i.getName().equals(j.getName())) {
                return false;
            }
            if (this.compareValues(i.getValue(), j.getValue())) continue;
            return false;
        }
        if (j.next()) {
            return false;
        }
        String[] acn = a.getChildNames();
        if (acn.length != (bcn = b.getChildNames()).length) {
            return false;
        }
        for (int i2 = 0; i2 < acn.length; ++i2) {
            if (!acn[i2].equals(bcn[i2])) {
                return false;
            }
            this.compareIntern(a.get(i2), b.get(i2));
        }
        return true;
    }

    private boolean compareValues(Object a, Object b) {
        if (a != null) {
            return a.equals(b);
        }
        return b == null;
    }
}

