/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.EmptyIterator;
import java.util.Collections;
import java.util.Iterator;

public class SimpleBeanPropertyDefinition
extends BeanPropertyDefinition {
    protected final AnnotationIntrospector _introspector;
    protected final AnnotatedMember _member;
    protected final PropertyMetadata _metadata;
    protected final PropertyName _fullName;
    protected final JsonInclude.Include _inclusion;
    @Deprecated
    protected final String _name;

    @Deprecated
    public SimpleBeanPropertyDefinition(AnnotatedMember member) {
        this(member, member.getName(), null);
    }

    @Deprecated
    public SimpleBeanPropertyDefinition(AnnotatedMember member, String name2) {
        this(member, new PropertyName(name2), null, null, null);
    }

    protected SimpleBeanPropertyDefinition(AnnotatedMember member, PropertyName fullName, AnnotationIntrospector intr, PropertyMetadata metadata, JsonInclude.Include inclusion2) {
        this._introspector = intr;
        this._member = member;
        this._fullName = fullName;
        this._name = fullName.getSimpleName();
        this._metadata = metadata == null ? PropertyMetadata.STD_OPTIONAL : metadata;
        this._inclusion = inclusion2;
    }

    @Deprecated
    protected SimpleBeanPropertyDefinition(AnnotatedMember member, String name2, AnnotationIntrospector intr) {
        this(member, new PropertyName(name2), intr, null, null);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member) {
        return new SimpleBeanPropertyDefinition(member, new PropertyName(member.getName()), config == null ? null : config.getAnnotationIntrospector(), null, null);
    }

    @Deprecated
    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member, String name2) {
        return new SimpleBeanPropertyDefinition(member, new PropertyName(name2), config == null ? null : config.getAnnotationIntrospector(), null, null);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member, PropertyName name2) {
        return SimpleBeanPropertyDefinition.construct(config, member, name2, null, null);
    }

    public static SimpleBeanPropertyDefinition construct(MapperConfig<?> config, AnnotatedMember member, PropertyName name2, PropertyMetadata metadata, JsonInclude.Include inclusion2) {
        return new SimpleBeanPropertyDefinition(member, name2, config == null ? null : config.getAnnotationIntrospector(), metadata, inclusion2);
    }

    @Override
    @Deprecated
    public BeanPropertyDefinition withName(String newName) {
        return this.withSimpleName(newName);
    }

    @Override
    public BeanPropertyDefinition withSimpleName(String newName) {
        if (this._fullName.hasSimpleName(newName) && !this._fullName.hasNamespace()) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._member, new PropertyName(newName), this._introspector, this._metadata, this._inclusion);
    }

    @Override
    public BeanPropertyDefinition withName(PropertyName newName) {
        if (this._fullName.equals(newName)) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._member, newName, this._introspector, this._metadata, this._inclusion);
    }

    public BeanPropertyDefinition withMetadata(PropertyMetadata metadata) {
        if (metadata.equals(this._metadata)) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._member, this._fullName, this._introspector, metadata, this._inclusion);
    }

    public BeanPropertyDefinition withInclusion(JsonInclude.Include inclusion2) {
        if (this._inclusion == inclusion2) {
            return this;
        }
        return new SimpleBeanPropertyDefinition(this._member, this._fullName, this._introspector, this._metadata, inclusion2);
    }

    @Override
    public String getName() {
        return this._fullName.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._fullName;
    }

    @Override
    public String getInternalName() {
        return this.getName();
    }

    @Override
    public PropertyName getWrapperName() {
        return this._introspector == null && this._member != null ? null : this._introspector.findWrapperName(this._member);
    }

    @Override
    public boolean isExplicitlyIncluded() {
        return false;
    }

    @Override
    public boolean isExplicitlyNamed() {
        return false;
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public JsonInclude.Include findInclusion() {
        return this._inclusion;
    }

    @Override
    public boolean hasGetter() {
        return this.getGetter() != null;
    }

    @Override
    public boolean hasSetter() {
        return this.getSetter() != null;
    }

    @Override
    public boolean hasField() {
        return this._member instanceof AnnotatedField;
    }

    @Override
    public boolean hasConstructorParameter() {
        return this._member instanceof AnnotatedParameter;
    }

    @Override
    public AnnotatedMethod getGetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 0) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    @Override
    public AnnotatedMethod getSetter() {
        if (this._member instanceof AnnotatedMethod && ((AnnotatedMethod)this._member).getParameterCount() == 1) {
            return (AnnotatedMethod)this._member;
        }
        return null;
    }

    @Override
    public AnnotatedField getField() {
        return this._member instanceof AnnotatedField ? (AnnotatedField)this._member : null;
    }

    @Override
    public AnnotatedParameter getConstructorParameter() {
        return this._member instanceof AnnotatedParameter ? (AnnotatedParameter)this._member : null;
    }

    @Override
    public Iterator<AnnotatedParameter> getConstructorParameters() {
        AnnotatedParameter param2 = this.getConstructorParameter();
        if (param2 == null) {
            return EmptyIterator.instance();
        }
        return Collections.singleton(param2).iterator();
    }

    @Override
    public AnnotatedMember getAccessor() {
        AnnotatedMember acc = this.getGetter();
        if (acc == null) {
            acc = this.getField();
        }
        return acc;
    }

    @Override
    public AnnotatedMember getMutator() {
        AnnotatedMember acc = this.getConstructorParameter();
        if (acc == null && (acc = this.getSetter()) == null) {
            acc = this.getField();
        }
        return acc;
    }

    @Override
    public AnnotatedMember getNonConstructorMutator() {
        AnnotatedMember acc = this.getSetter();
        if (acc == null) {
            acc = this.getField();
        }
        return acc;
    }

    @Override
    public AnnotatedMember getPrimaryMember() {
        return this._member;
    }
}

