/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;

public class TypeNameIdResolver
extends TypeIdResolverBase {
    protected final MapperConfig<?> _config;
    protected final HashMap<String, String> _typeToId;
    protected final HashMap<String, JavaType> _idToType;

    protected TypeNameIdResolver(MapperConfig<?> config, JavaType baseType, HashMap<String, String> typeToId, HashMap<String, JavaType> idToType) {
        super(baseType, config.getTypeFactory());
        this._config = config;
        this._typeToId = typeToId;
        this._idToType = idToType;
    }

    public static TypeNameIdResolver construct(MapperConfig<?> config, JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (forSer == forDeser) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> typeToId = null;
        HashMap<String, JavaType> idToType = null;
        if (forSer) {
            typeToId = new HashMap<String, String>();
        }
        if (forDeser) {
            idToType = new HashMap<String, JavaType>();
        }
        if (subtypes != null) {
            for (NamedType t : subtypes) {
                JavaType prev;
                String id;
                Class<?> cls = t.getType();
                String string2 = id = t.hasName() ? t.getName() : TypeNameIdResolver._defaultTypeId(cls);
                if (forSer) {
                    typeToId.put(cls.getName(), id);
                }
                if (!forDeser || (prev = idToType.get(id)) != null && cls.isAssignableFrom(prev.getRawClass())) continue;
                idToType.put(id, config.constructType(cls));
            }
        }
        return new TypeNameIdResolver(config, baseType, typeToId, idToType);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String idFromValue(Object value) {
        String name2;
        Class<?> cls = this._typeFactory.constructType(value.getClass()).getRawClass();
        String key = cls.getName();
        HashMap<String, String> hashMap = this._typeToId;
        synchronized (hashMap) {
            name2 = this._typeToId.get(key);
            if (name2 == null) {
                if (this._config.isAnnotationProcessingEnabled()) {
                    BeanDescription beanDesc = this._config.introspectClassAnnotations(cls);
                    name2 = this._config.getAnnotationIntrospector().findTypeName(beanDesc.getClassInfo());
                }
                if (name2 == null) {
                    name2 = TypeNameIdResolver._defaultTypeId(cls);
                }
                this._typeToId.put(key, name2);
            }
        }
        return name2;
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        return this.idFromValue(value);
    }

    @Override
    @Deprecated
    public JavaType typeFromId(String id) {
        return this._typeFromId(id);
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        return this._typeFromId(id);
    }

    protected JavaType _typeFromId(String id) {
        return this._idToType.get(id);
    }

    @Override
    public String getDescForKnownTypeIds() {
        return new TreeSet<String>(this._idToType.keySet()).toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getClass().getName());
        sb.append("; id-to-type=").append(this._idToType);
        sb.append(']');
        return sb.toString();
    }

    protected static String _defaultTypeId(Class<?> cls) {
        String n = cls.getName();
        int ix = n.lastIndexOf(46);
        return ix < 0 ? n : n.substring(ix + 1);
    }
}

