/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.jsf;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.util.WebUtils;

public abstract class FacesContextUtils {
    public static WebApplicationContext getWebApplicationContext(FacesContext fc) {
        Assert.notNull(fc, "FacesContext must not be null");
        Object attr2 = fc.getExternalContext().getApplicationMap().get(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        if (attr2 == null) {
            return null;
        }
        if (attr2 instanceof RuntimeException) {
            throw (RuntimeException)attr2;
        }
        if (attr2 instanceof Error) {
            throw (Error)attr2;
        }
        if (!(attr2 instanceof WebApplicationContext)) {
            throw new IllegalStateException("Root context attribute is not of type WebApplicationContext: " + attr2);
        }
        return (WebApplicationContext)attr2;
    }

    public static WebApplicationContext getRequiredWebApplicationContext(FacesContext fc) throws IllegalStateException {
        WebApplicationContext wac = FacesContextUtils.getWebApplicationContext(fc);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    public static Object getSessionMutex(FacesContext fc) {
        Assert.notNull(fc, "FacesContext must not be null");
        ExternalContext ec = fc.getExternalContext();
        Object mutex = ec.getSessionMap().get(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = ec.getSession(true);
        }
        return mutex;
    }
}

