/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import java.util.Properties;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.web.context.ServletContextAware;

public class ServletContextPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements ServletContextAware {
    private boolean contextOverride = false;
    private boolean searchContextAttributes = false;
    private ServletContext servletContext;

    public void setContextOverride(boolean contextOverride) {
        this.contextOverride = contextOverride;
    }

    public void setSearchContextAttributes(boolean searchContextAttributes) {
        this.searchContextAttributes = searchContextAttributes;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value2 = null;
        if (this.contextOverride && this.servletContext != null) {
            value2 = this.resolvePlaceholder(placeholder, this.servletContext, this.searchContextAttributes);
        }
        if (value2 == null) {
            value2 = super.resolvePlaceholder(placeholder, props);
        }
        if (value2 == null && this.servletContext != null) {
            value2 = this.resolvePlaceholder(placeholder, this.servletContext, this.searchContextAttributes);
        }
        return value2;
    }

    protected String resolvePlaceholder(String placeholder, ServletContext servletContext, boolean searchContextAttributes) {
        Object attrValue;
        String value2 = null;
        if (searchContextAttributes && (attrValue = servletContext.getAttribute(placeholder)) != null) {
            value2 = attrValue.toString();
        }
        if (value2 == null) {
            value2 = servletContext.getInitParameter(placeholder);
        }
        return value2;
    }
}

