/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class AbstractRequestAttributesScope
implements Scope {
    public Object get(String name2, ObjectFactory objectFactory) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = attributes.getAttribute(name2, this.getScope());
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            attributes.setAttribute(name2, scopedObject, this.getScope());
        }
        return scopedObject;
    }

    public Object remove(String name2) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        Object scopedObject = attributes.getAttribute(name2, this.getScope());
        if (scopedObject != null) {
            attributes.removeAttribute(name2, this.getScope());
            return scopedObject;
        }
        return null;
    }

    public void registerDestructionCallback(String name2, Runnable callback) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        attributes.registerDestructionCallback(name2, callback, this.getScope());
    }

    protected abstract int getScope();
}

