/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;

public abstract class AbstractRequestAttributes
implements RequestAttributes {
    protected final Map requestDestructionCallbacks = new LinkedHashMap(8);
    private volatile boolean requestActive = true;

    public void requestCompleted() {
        this.executeRequestDestructionCallbacks();
        this.updateAccessedSessionAttributes();
        this.requestActive = false;
    }

    protected final boolean isRequestActive() {
        return this.requestActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void registerRequestDestructionCallback(String name2, Runnable callback) {
        Assert.notNull(name2, "Name must not be null");
        Assert.notNull(callback, "Callback must not be null");
        Map map2 = this.requestDestructionCallbacks;
        synchronized (map2) {
            this.requestDestructionCallbacks.put(name2, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeRequestDestructionCallback(String name2) {
        Assert.notNull(name2, "Name must not be null");
        Map map2 = this.requestDestructionCallbacks;
        synchronized (map2) {
            this.requestDestructionCallbacks.remove(name2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRequestDestructionCallbacks() {
        Map map2 = this.requestDestructionCallbacks;
        synchronized (map2) {
            Iterator it = this.requestDestructionCallbacks.values().iterator();
            while (it.hasNext()) {
                ((Runnable)it.next()).run();
            }
            this.requestDestructionCallbacks.clear();
        }
    }

    protected abstract void updateAccessedSessionAttributes();
}

