/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.support;

import java.util.Map;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.validation.BindingResult;

public class BindingAwareModelMap
extends ExtendedModelMap {
    public Object put(Object key, Object value2) {
        this.removeBindingResultIfNecessary(key, value2);
        return super.put(key, value2);
    }

    public void putAll(Map map2) {
        for (Map.Entry entry : map2.entrySet()) {
            this.removeBindingResultIfNecessary(entry.getKey(), entry.getValue());
        }
        super.putAll(map2);
    }

    private void removeBindingResultIfNecessary(Object key, Object value2) {
        String bindingResultKey;
        BindingResult bindingResult;
        String attributeName;
        if (key instanceof String && !(attributeName = (String)key).startsWith(BindingResult.MODEL_KEY_PREFIX) && (bindingResult = (BindingResult)this.get(bindingResultKey = BindingResult.MODEL_KEY_PREFIX + attributeName)) != null && bindingResult.getTarget() != value2) {
            this.remove(bindingResultKey);
        }
    }
}

