/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.StringUtils;
import org.springframework.validation.MessageCodesResolver;

public class DefaultMessageCodesResolver
implements MessageCodesResolver,
Serializable {
    public static final String CODE_SEPARATOR = ".";
    private String prefix = "";

    public void setPrefix(String prefix) {
        this.prefix = prefix != null ? prefix : "";
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public String[] resolveMessageCodes(String errorCode, String objectName) {
        return new String[]{this.postProcessMessageCode(errorCode + CODE_SEPARATOR + objectName), this.postProcessMessageCode(errorCode)};
    }

    public String[] resolveMessageCodes(String errorCode, String objectName, String field2, Class fieldType) {
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList fieldList = new ArrayList();
        this.buildFieldList(field2, fieldList);
        Iterator it = fieldList.iterator();
        while (it.hasNext()) {
            String fieldInList = (String)it.next();
            codeList.add(this.postProcessMessageCode(errorCode + CODE_SEPARATOR + objectName + CODE_SEPARATOR + fieldInList));
        }
        int dotIndex = field2.lastIndexOf(46);
        if (dotIndex != -1) {
            this.buildFieldList(field2.substring(dotIndex + 1), fieldList);
        }
        Iterator it2 = fieldList.iterator();
        while (it2.hasNext()) {
            String fieldInList = (String)it2.next();
            codeList.add(this.postProcessMessageCode(errorCode + CODE_SEPARATOR + fieldInList));
        }
        if (fieldType != null) {
            codeList.add(this.postProcessMessageCode(errorCode + CODE_SEPARATOR + fieldType.getName()));
        }
        codeList.add(this.postProcessMessageCode(errorCode));
        return StringUtils.toStringArray(codeList);
    }

    protected void buildFieldList(String field2, List fieldList) {
        fieldList.add(field2);
        String plainField = field2;
        int keyIndex = plainField.lastIndexOf(91);
        while (keyIndex != -1) {
            int endKeyIndex = plainField.indexOf(93, keyIndex);
            if (endKeyIndex != -1) {
                plainField = plainField.substring(0, keyIndex) + plainField.substring(endKeyIndex + 1);
                fieldList.add(plainField);
                keyIndex = plainField.lastIndexOf(91);
                continue;
            }
            keyIndex = -1;
        }
    }

    protected String postProcessMessageCode(String code) {
        return this.getPrefix() + code;
    }
}

