/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.springframework.beans.PropertyAccessException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class DefaultBindingErrorProcessor
implements BindingErrorProcessor {
    public static final String MISSING_FIELD_ERROR_CODE = "required";

    public void processMissingFieldError(String missingField, BindingResult bindingResult) {
        String fixedField = bindingResult.getNestedPath() + missingField;
        String[] codes2 = bindingResult.resolveMessageCodes(MISSING_FIELD_ERROR_CODE, missingField);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), fixedField);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), fixedField, "", true, codes2, arguments, "Field '" + fixedField + "' is required"));
    }

    public void processPropertyAccessException(PropertyAccessException ex, BindingResult bindingResult) {
        String field2 = ex.getPropertyChangeEvent().getPropertyName();
        Object value2 = ex.getPropertyChangeEvent().getNewValue();
        String[] codes2 = bindingResult.resolveMessageCodes(ex.getErrorCode(), field2);
        Object[] arguments = this.getArgumentsForBindError(bindingResult.getObjectName(), field2);
        bindingResult.addError(new FieldError(bindingResult.getObjectName(), field2, value2, true, codes2, arguments, ex.getLocalizedMessage()));
    }

    protected Object[] getArgumentsForBindError(String objectName, String field2) {
        String[] codes2 = new String[]{objectName + "." + field2, field2};
        String defaultMessage = field2;
        return new Object[]{new DefaultMessageSourceResolvable(codes2, defaultMessage)};
    }
}

