/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.util.Assert;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DomUtils {
    public static List getChildElementsByTagName(Element ele, String[] childEleNames) {
        Assert.notNull(ele, "Element must not be null");
        Assert.notNull(childEleNames, "Element names collection must not be null");
        List<String> childEleNameList = Arrays.asList(childEleNames);
        NodeList nl = ele.getChildNodes();
        ArrayList<Node> childEles = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameMatch(node, childEleNameList)) continue;
            childEles.add(node);
        }
        return childEles;
    }

    public static List getChildElementsByTagName(Element ele, String childEleName) {
        return DomUtils.getChildElementsByTagName(ele, new String[]{childEleName});
    }

    public static Element getChildElementByTagName(Element ele, String childEleName) {
        Assert.notNull(ele, "Element must not be null");
        Assert.notNull(childEleName, "Element name must not be null");
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !DomUtils.nodeNameMatch(node, childEleName)) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getChildElementValueByTagName(Element ele, String childEleName) {
        Element child = DomUtils.getChildElementByTagName(ele, childEleName);
        return child != null ? DomUtils.getTextValue(child) : null;
    }

    public static String getTextValue(Element valueEle) {
        Assert.notNull(valueEle, "Element must not be null");
        StringBuffer value2 = new StringBuffer();
        NodeList nl = valueEle.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
            value2.append(item.getNodeValue());
        }
        return value2.toString();
    }

    public static boolean nodeNameEquals(Node node, String desiredName) {
        Assert.notNull(node, "Node must not be null");
        Assert.notNull(desiredName, "Desired name must not be null");
        return DomUtils.nodeNameMatch(node, desiredName);
    }

    private static boolean nodeNameMatch(Node node, String desiredName) {
        return desiredName.equals(node.getNodeName()) || desiredName.equals(node.getLocalName());
    }

    private static boolean nodeNameMatch(Node node, Collection desiredNames) {
        return desiredNames.contains(node.getNodeName()) || desiredNames.contains(node.getLocalName());
    }
}

