/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.comparator.InvertibleComparator;

public class CompoundComparator
implements Comparator,
Serializable {
    private final List comparators;

    public CompoundComparator() {
        this.comparators = new ArrayList();
    }

    public CompoundComparator(Comparator[] comparators) {
        this.comparators = new ArrayList(comparators.length);
        for (int i = 0; i < comparators.length; ++i) {
            this.addComparator(comparators[i]);
        }
    }

    public void addComparator(Comparator comparator) {
        if (comparator instanceof InvertibleComparator) {
            this.comparators.add(comparator);
        } else {
            this.comparators.add(new InvertibleComparator(comparator));
        }
    }

    public void addComparator(Comparator comparator, boolean ascending) {
        this.comparators.add(new InvertibleComparator(comparator, ascending));
    }

    public void setComparator(int index2, Comparator comparator) {
        if (comparator instanceof InvertibleComparator) {
            this.comparators.set(index2, comparator);
        } else {
            InvertibleComparator invComp = new InvertibleComparator(comparator);
            this.comparators.set(index2, invComp);
        }
    }

    public void setComparator(int index2, Comparator comparator, boolean ascending) {
        InvertibleComparator invComp = new InvertibleComparator(comparator, ascending);
        this.comparators.set(index2, invComp);
    }

    public void invertOrder() {
        Iterator it = this.comparators.iterator();
        while (it.hasNext()) {
            ((InvertibleComparator)it.next()).invertOrder();
        }
    }

    public void invertOrder(int index2) {
        this.getInvertibleComparator(index2).invertOrder();
    }

    public void setAscendingOrder(int index2) {
        this.getInvertibleComparator(index2).setAscending(true);
    }

    public void setDescendingOrder(int index2) {
        this.getInvertibleComparator(index2).setAscending(false);
    }

    private InvertibleComparator getInvertibleComparator(int index2) {
        return (InvertibleComparator)this.comparators.get(index2);
    }

    public int getComparatorCount() {
        return this.comparators.size();
    }

    public int compare(Object o1, Object o2) {
        Assert.state(this.comparators.size() > 0, "No sort definitions have been added to this CompoundComparator to compare");
        Iterator it = this.comparators.iterator();
        while (it.hasNext()) {
            InvertibleComparator def = (InvertibleComparator)it.next();
            int result2 = def.compare(o1, o2);
            if (result2 == 0) continue;
            return result2;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompoundComparator)) {
            return false;
        }
        CompoundComparator other = (CompoundComparator)obj;
        return ((Object)this.comparators).equals(other.comparators);
    }

    public int hashCode() {
        return ((Object)this.comparators).hashCode();
    }

    public String toString() {
        return "CompoundComparator: " + this.comparators;
    }
}

