/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class TypeUtils {
    public static boolean isAssignable(Type lhsType, Type rhsType) {
        Assert.notNull(lhsType, "Left-hand side type must not be null");
        Assert.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.equals(rhsType)) {
            return true;
        }
        if (lhsType instanceof Class && rhsType instanceof Class) {
            return ClassUtils.isAssignable((Class)lhsType, (Class)rhsType);
        }
        if (lhsType instanceof ParameterizedType && rhsType instanceof ParameterizedType) {
            return TypeUtils.isAssignable((ParameterizedType)lhsType, (ParameterizedType)rhsType);
        }
        if (lhsType instanceof WildcardType) {
            return TypeUtils.isAssignable((WildcardType)lhsType, rhsType);
        }
        return false;
    }

    private static boolean isAssignable(ParameterizedType lhsType, ParameterizedType rhsType) {
        Type[] rhsTypeArguments;
        if (lhsType.equals(rhsType)) {
            return true;
        }
        Type[] lhsTypeArguments = lhsType.getActualTypeArguments();
        if (lhsTypeArguments.length != (rhsTypeArguments = rhsType.getActualTypeArguments()).length) {
            return false;
        }
        int size2 = lhsTypeArguments.length;
        for (int i = 0; i < size2; ++i) {
            Type lhsArg = lhsTypeArguments[i];
            Type rhsArg = rhsTypeArguments[i];
            if (lhsArg.equals(rhsArg) || lhsArg instanceof WildcardType && TypeUtils.isAssignable((WildcardType)lhsArg, rhsArg)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(WildcardType lhsType, Type rhsType) {
        int i;
        Type[] upperBounds = lhsType.getUpperBounds();
        Type[] lowerBounds = lhsType.getLowerBounds();
        int size2 = upperBounds.length;
        for (i = 0; i < size2; ++i) {
            if (TypeUtils.isAssignable(upperBounds[i], rhsType)) continue;
            return false;
        }
        size2 = lowerBounds.length;
        for (i = 0; i < size2; ++i) {
            if (TypeUtils.isAssignable(rhsType, lowerBounds[i])) continue;
            return false;
        }
        return true;
    }
}

