/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.util.Assert;

public abstract class ReflectionUtils {
    public static FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        public boolean matches(Field field2) {
            return !Modifier.isStatic(field2.getModifiers()) && !Modifier.isFinal(field2.getModifiers());
        }
    };

    public static Field findField(Class clazz, String name2) {
        return ReflectionUtils.findField(clazz, name2, null);
    }

    public static Field findField(Class clazz, String name2, Class type) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.isTrue(name2 != null || type != null, "Either name or type of the field must be specified");
        for (Class searchType = clazz; !(class$java$lang$Object == null ? ReflectionUtils.class$("java.lang.Object") : class$java$lang$Object).equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields = searchType.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field2 = fields[i];
                if (name2 != null && !name2.equals(field2.getName()) || type != null && !type.equals(field2.getType())) continue;
                return field2;
            }
        }
        return null;
    }

    public static void setField(Field field2, Object target, Object value2) {
        try {
            field2.set(target, value2);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Object getField(Field field2, Object target) {
        try {
            return field2.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Method findMethod(Class clazz, String name2) {
        return ReflectionUtils.findMethod(clazz, name2, new Class[0]);
    }

    public static Method findMethod(Class clazz, String name2, Class[] paramTypes) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(name2, "Method name must not be null");
        for (Class searchType = clazz; !(class$java$lang$Object == null ? ReflectionUtils.class$("java.lang.Object") : class$java$lang$Object).equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!name2.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, null);
    }

    public static Object invokeMethod(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeJdbcMethod(Method method, Object target) throws SQLException {
        return ReflectionUtils.invokeJdbcMethod(method, target, null);
    }

    public static Object invokeJdbcMethod(Method method, Object target, Object[] args) throws SQLException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SQLException) {
                throw (SQLException)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        ReflectionUtils.handleUnexpectedException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ReflectionUtils.handleUnexpectedException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        ReflectionUtils.handleUnexpectedException(ex);
    }

    private static void handleUnexpectedException(Throwable ex) {
        IllegalStateException isex = new IllegalStateException("Unexpected exception thrown");
        isex.initCause(ex);
        throw isex;
    }

    public static boolean declaresException(Method method, Class exceptionType) {
        Assert.notNull(method, "Method must not be null");
        Class<?>[] declaredExceptions = method.getExceptionTypes();
        for (int i = 0; i < declaredExceptions.length; ++i) {
            Class<?> declaredException = declaredExceptions[i];
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicStaticFinal(Field field2) {
        int modifiers = field2.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static void makeAccessible(Field field2) {
        if (!Modifier.isPublic(field2.getModifiers()) || !Modifier.isPublic(field2.getDeclaringClass().getModifiers())) {
            field2.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor ctor) {
        if (!Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers())) {
            ctor.setAccessible(true);
        }
    }

    public static void doWithMethods(Class targetClass, MethodCallback mc) throws IllegalArgumentException {
        ReflectionUtils.doWithMethods(targetClass, mc, null);
    }

    public static void doWithMethods(Class targetClass, MethodCallback mc, MethodFilter mf) throws IllegalArgumentException {
        do {
            Method[] methods = targetClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (mf != null && !mf.matches(methods[i])) continue;
                try {
                    mc.doWith(methods[i]);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access method '" + methods[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null);
    }

    public static Method[] getAllDeclaredMethods(Class leafClass) throws IllegalArgumentException {
        final ArrayList list2 = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, new MethodCallback(){

            public void doWith(Method method) {
                list2.add(method);
            }
        });
        return list2.toArray(new Method[list2.size()]);
    }

    public static void doWithFields(Class targetClass, FieldCallback fc) throws IllegalArgumentException {
        ReflectionUtils.doWithFields(targetClass, fc, null);
    }

    public static void doWithFields(Class targetClass, FieldCallback fc, FieldFilter ff) throws IllegalArgumentException {
        do {
            Field[] fields = targetClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (ff != null && !ff.matches(fields[i])) continue;
                try {
                    fc.doWith(fields[i]);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Shouldn't be illegal to access field '" + fields[i].getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != (class$java$lang$Object == null ? ReflectionUtils.class$("java.lang.Object") : class$java$lang$Object));
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), new FieldCallback(){

            public void doWith(Field field2) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible(field2);
                Object srcValue = field2.get(src);
                field2.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

