/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class NumberUtils {
    private static final boolean decimalFormatSupportsBigDecimal = ClassUtils.hasMethod(DecimalFormat.class, "setParseBigDecimal", new Class[]{Boolean.TYPE});

    public static Number convertNumberToTargetClass(Number number2, Class targetClass) throws IllegalArgumentException {
        Assert.notNull(number2, "Number must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number2)) {
            return number2;
        }
        if (targetClass.equals(Byte.class)) {
            long value2 = number2.longValue();
            if (value2 < -128L || value2 > 127L) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return new Byte(number2.byteValue());
        }
        if (targetClass.equals(Short.class)) {
            long value3 = number2.longValue();
            if (value3 < -32768L || value3 > 32767L) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return new Short(number2.shortValue());
        }
        if (targetClass.equals(Integer.class)) {
            long value4 = number2.longValue();
            if (value4 < Integer.MIN_VALUE || value4 > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return new Integer(number2.intValue());
        }
        if (targetClass.equals(Long.class)) {
            return new Long(number2.longValue());
        }
        if (targetClass.equals(BigInteger.class)) {
            if (number2 instanceof BigDecimal) {
                return ((BigDecimal)number2).toBigInteger();
            }
            return BigInteger.valueOf(number2.longValue());
        }
        if (targetClass.equals(Float.class)) {
            return new Float(number2.floatValue());
        }
        if (targetClass.equals(Double.class)) {
            return new Double(number2.doubleValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return new BigDecimal(number2.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number2, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static Number parseNumber(String text2, Class targetClass) {
        Assert.notNull(text2, "Text must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        String trimmed = StringUtils.trimAllWhitespace(text2);
        if (targetClass.equals(Byte.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed);
        }
        if (targetClass.equals(Short.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed);
        }
        if (targetClass.equals(Integer.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed);
        }
        if (targetClass.equals(Long.class)) {
            return NumberUtils.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed);
        }
        if (targetClass.equals(BigInteger.class)) {
            return NumberUtils.isHexNumber(trimmed) ? NumberUtils.decodeBigInteger(trimmed) : new BigInteger(trimmed);
        }
        if (targetClass.equals(Float.class)) {
            return Float.valueOf(trimmed);
        }
        if (targetClass.equals(Double.class)) {
            return Double.valueOf(trimmed);
        }
        if (targetClass.equals(BigDecimal.class) || targetClass.equals(Number.class)) {
            return new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text2 + "] to target class [" + targetClass.getName() + "]");
    }

    public static Number parseNumber(String text2, Class targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull(text2, "Text must not be null");
            Assert.notNull(targetClass, "Target class must not be null");
            DecimalFormat decimalFormat = null;
            boolean resetBigDecimal = false;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                if (BigDecimal.class.equals(targetClass) && decimalFormatSupportsBigDecimal && !decimalFormat.isParseBigDecimal()) {
                    decimalFormat.setParseBigDecimal(true);
                    resetBigDecimal = true;
                }
            }
            try {
                Number number2 = numberFormat.parse(StringUtils.trimAllWhitespace(text2));
                Number number3 = NumberUtils.convertNumberToTargetClass(number2, targetClass);
                Object var8_9 = null;
                if (resetBigDecimal) {
                    decimalFormat.setParseBigDecimal(false);
                }
                return number3;
            }
            catch (ParseException ex) {
                try {
                    IllegalArgumentException iae = new IllegalArgumentException("Could not parse number: " + ex.getMessage());
                    iae.initCause(ex);
                    throw iae;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (resetBigDecimal) {
                        decimalFormat.setParseBigDecimal(false);
                    }
                    throw throwable;
                }
            }
        }
        return NumberUtils.parseNumber(text2, targetClass);
    }

    private static boolean isHexNumber(String value2) {
        int index2 = value2.startsWith("-") ? 1 : 0;
        return value2.startsWith("0x", index2) || value2.startsWith("0X", index2) || value2.startsWith("#", index2);
    }

    private static BigInteger decodeBigInteger(String value2) {
        int radix = 10;
        int index2 = 0;
        boolean negative = false;
        if (value2.startsWith("-")) {
            negative = true;
            ++index2;
        }
        if (value2.startsWith("0x", index2) || value2.startsWith("0X", index2)) {
            index2 += 2;
            radix = 16;
        } else if (value2.startsWith("#", index2)) {
            ++index2;
            radix = 16;
        } else if (value2.startsWith("0", index2) && value2.length() > 1 + index2) {
            ++index2;
            radix = 8;
        }
        BigInteger result2 = new BigInteger(value2.substring(index2), radix);
        return negative ? result2.negate() : result2;
    }
}

