/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.File;
import java.io.IOException;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public abstract class FileSystemUtils {
    public static boolean deleteRecursively(File root2) {
        if (root2 != null && root2.exists()) {
            File[] children;
            if (root2.isDirectory() && (children = root2.listFiles()) != null) {
                for (int i = 0; i < children.length; ++i) {
                    FileSystemUtils.deleteRecursively(children[i]);
                }
            }
            return root2.delete();
        }
        return false;
    }

    public static void copyRecursively(File src, File dest) throws IOException {
        Assert.isTrue(src != null && (src.isDirectory() || src.isFile()), "Source File must denote a directory or file");
        Assert.notNull(dest, "Destination File must not be null");
        FileSystemUtils.doCopyRecursively(src, dest);
    }

    private static void doCopyRecursively(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            dest.mkdir();
            File[] entries = src.listFiles();
            if (entries == null) {
                throw new IOException("Could not list files in directory: " + src);
            }
            for (int i = 0; i < entries.length; ++i) {
                File file = entries[i];
                FileSystemUtils.doCopyRecursively(file, new File(dest, file.getName()));
            }
        } else if (src.isFile()) {
            try {
                dest.createNewFile();
            }
            catch (IOException ex) {
                IOException ioex = new IOException("Failed to create file: " + dest);
                ioex.initCause(ex);
                throw ioex;
            }
            FileCopyUtils.copy(src, dest);
        }
    }
}

